/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.mapred.Reporter;

public class AutoProgressor {
    protected Log LOG = LogFactory.getLog(this.getClass().getName());
    Timer rpTimer = null;
    Timer srpTimer = null;
    String logClassName = null;
    int notificationInterval;
    long timeout;
    Reporter reporter;

    AutoProgressor(String logClassName, Reporter reporter, int notificationInterval) {
        this.logClassName = logClassName;
        this.reporter = reporter;
        this.notificationInterval = notificationInterval;
        this.timeout = 0L;
    }

    AutoProgressor(String logClassName, Reporter reporter, int notificationInterval, long timeout) {
        this.logClassName = logClassName;
        this.reporter = reporter;
        this.notificationInterval = notificationInterval;
        this.timeout = timeout;
    }

    public void go() {
        this.LOG.info("Running ReporterTask every " + this.notificationInterval + " miliseconds.");
        this.rpTimer = new Timer(true);
        ReporterTask rt = new ReporterTask(this.reporter);
        this.rpTimer.scheduleAtFixedRate((TimerTask)rt, 0L, (long)this.notificationInterval);
        if (this.timeout > 0L) {
            this.srpTimer = new Timer(true);
            StopReporterTimerTask srt = new StopReporterTimerTask(rt);
            this.srpTimer.schedule((TimerTask)srt, this.timeout);
        }
    }

    class StopReporterTimerTask
    extends TimerTask {
        private final ReporterTask rt;

        public StopReporterTimerTask(ReporterTask rp) {
            this.rt = rp;
        }

        @Override
        public void run() {
            if (this.rt != null) {
                AutoProgressor.this.LOG.info("Stopping reporter timer for " + AutoProgressor.this.logClassName);
                this.rt.cancel();
            }
        }
    }

    class ReporterTask
    extends TimerTask {
        private Reporter rp;

        public ReporterTask(Reporter rp) {
            if (rp != null) {
                this.rp = rp;
            }
        }

        @Override
        public void run() {
            if (this.rp != null) {
                AutoProgressor.this.LOG.info("ReporterTask calling reporter.progress() for " + AutoProgressor.this.logClassName);
                this.rp.progress();
            }
        }
    }
}

