/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorMapJoinInnerLongOperator
extends VectorMapJoinInnerGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(VectorMapJoinInnerLongOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinInnerLongOperator.class.getName();
    private transient VectorMapJoinLongHashMap hashMap;
    private transient boolean useMinMax;
    private transient long min;
    private transient long max;
    private transient int singleJoinColumn;

    public VectorMapJoinInnerLongOperator() {
    }

    public VectorMapJoinInnerLongOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinLongHashMap)this.vectorMapJoinHashTable;
                this.useMinMax = this.hashMap.useMinMax();
                if (this.useMinMax) {
                    this.min = this.hashMap.min();
                    this.max = this.hashMap.max();
                }
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            this.innerPerBatchSetup(batch);
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " empty");
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            int numSel = 0;
            LongColumnVector joinColVector = (LongColumnVector)batch.cols[this.singleJoinColumn];
            long[] vector = joinColVector.vector;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                long key = vector[0];
                JoinUtil.JoinResult joinResult = this.useMinMax && (key < this.min || key > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMap.lookup(key, this.hashMapResults[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                numSel = this.finishInnerRepeated(batch, joinResult, this.hashMapResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                long saveKey = 0L;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    long currentKey = vector[batchIndex];
                    if (!haveSaveKey || currentKey != saveKey) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++hashMapResultCount;
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        saveKey = currentKey;
                        saveJoinResult = this.useMinMax && (currentKey < this.min || currentKey > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMap.lookup(currentKey, this.hashMapResults[hashMapResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesHashMapResultIndices[equalKeySeriesCount] = hashMapResultCount;
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesIsSingleValue[equalKeySeriesCount] = this.hashMapResults[hashMapResultCount].isSingleRow();
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n] = this.equalKeySeriesDuplicateCounts[n] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++hashMapResultCount;
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " allMatchs " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesHashMapResultIndices " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.equalKeySeriesHashMapResultIndices, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesIsSingleValue " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesIsSingleValue, 0, equalKeySeriesCount)) + " equalKeySeriesDuplicateCounts " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesDuplicateCounts, 0, equalKeySeriesCount)) + " spills " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount)));
                }
                numSel = this.finishInner(batch, this.allMatchs, allMatchCount, this.equalKeySeriesHashMapResultIndices, this.equalKeySeriesAllMatchIndices, this.equalKeySeriesIsSingleValue, this.equalKeySeriesDuplicateCounts, equalKeySeriesCount, this.spills, this.spillHashMapResultIndices, spillCount, this.hashMapResults, hashMapResultCount);
            }
            batch.selectedInUse = true;
            batch.size = numSel;
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

