/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMultiSet;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.io.BytesWritable;

public class VectorMapJoinFastLongHashMultiSet
extends VectorMapJoinFastLongHashTable
implements VectorMapJoinLongHashMultiSet {
    public static final Log LOG = LogFactory.getLog(VectorMapJoinFastLongHashMultiSet.class);

    @Override
    public VectorMapJoinHashMultiSetResult createHashMultiSetResult() {
        return new VectorMapJoinFastHashMultiSet.HashMultiSetResult();
    }

    @Override
    public void assignSlot(int slot, long key, boolean isNewKey, BytesWritable currentValue) {
        int pairIndex = 2 * slot;
        if (isNewKey) {
            this.slotPairs[pairIndex] = 1L;
            this.slotPairs[pairIndex + 1] = key;
        } else {
            int n = pairIndex;
            this.slotPairs[n] = this.slotPairs[n] + 1L;
        }
    }

    @Override
    public JoinUtil.JoinResult contains(long key, VectorMapJoinHashMultiSetResult hashMultiSetResult) {
        JoinUtil.JoinResult joinResult;
        VectorMapJoinFastHashMultiSet.HashMultiSetResult optimizedHashMultiSetResult = (VectorMapJoinFastHashMultiSet.HashMultiSetResult)hashMultiSetResult;
        optimizedHashMultiSetResult.forget();
        long hashCode = VectorMapJoinFastLongHashUtil.hashKey(key);
        long count = this.findReadSlot(key, hashCode);
        if (count == -1L) {
            joinResult = JoinUtil.JoinResult.NOMATCH;
        } else {
            optimizedHashMultiSetResult.set(count);
            joinResult = JoinUtil.JoinResult.MATCH;
        }
        optimizedHashMultiSetResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastLongHashMultiSet(boolean minMaxEnabled, boolean isOuterJoin, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize) {
        super(minMaxEnabled, isOuterJoin, hashTableKeyType, initialCapacity, loadFactor, writeBuffersSize);
    }
}

