/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class Cleaner
extends CompactorThread {
    private static final String CLASS_NAME = Cleaner.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    private long cleanerCheckInterval = 0L;
    private Map<Long, Set<Long>> compactId2LockMap = new HashMap<Long, Set<Long>>();
    private Map<Long, CompactionInfo> compactId2CompactInfoMap = new HashMap<Long, CompactionInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.cleanerCheckInterval == 0L) {
            this.cleanerCheckInterval = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, TimeUnit.MILLISECONDS);
        }
        do {
            long elapsedTime;
            boolean setLooped = !this.looped.get();
            long startedAt = System.currentTimeMillis();
            try {
                List<CompactionInfo> toClean = this.txnHandler.findReadyToClean();
                if (toClean.size() > 0 || this.compactId2LockMap.size() > 0) {
                    ShowLocksResponse locksResponse = this.txnHandler.showLocks(new ShowLocksRequest());
                    for (CompactionInfo ci : toClean) {
                        if (this.compactId2LockMap.containsKey(ci.id)) continue;
                        this.compactId2LockMap.put(ci.id, this.findRelatedLocks(ci, locksResponse));
                        this.compactId2CompactInfoMap.put(ci.id, ci);
                    }
                    Set<Long> currentLocks = this.buildCurrentLockSet(locksResponse);
                    ArrayList<Long> expiredLocks = new ArrayList<Long>();
                    ArrayList<Long> compactionsCleaned = new ArrayList<Long>();
                    try {
                        for (Map.Entry<Long, Set<Long>> queueEntry : this.compactId2LockMap.entrySet()) {
                            boolean sawLock = false;
                            for (Long lockId : queueEntry.getValue()) {
                                if (currentLocks.contains(lockId)) {
                                    sawLock = true;
                                    break;
                                }
                                expiredLocks.add(lockId);
                            }
                            if (!sawLock) {
                                compactionsCleaned.add(queueEntry.getKey());
                                this.clean(this.compactId2CompactInfoMap.get(queueEntry.getKey()));
                                continue;
                            }
                            for (Long lockId : expiredLocks) {
                                queueEntry.getValue().remove(lockId);
                            }
                        }
                    }
                    finally {
                        if (compactionsCleaned.size() > 0) {
                            for (Long compactId : compactionsCleaned) {
                                this.compactId2LockMap.remove(compactId);
                                this.compactId2CompactInfoMap.remove(compactId);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Caught an exception in the main loop of compactor cleaner, " + StringUtils.stringifyException((Throwable)t));
            }
            if (setLooped) {
                this.looped.set(true);
            }
            if ((elapsedTime = System.currentTimeMillis() - startedAt) >= this.cleanerCheckInterval || this.stop.get()) continue;
            try {
                Thread.sleep(this.cleanerCheckInterval - elapsedTime);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while (!this.stop.get());
    }

    private Set<Long> findRelatedLocks(CompactionInfo ci, ShowLocksResponse locksResponse) {
        HashSet<Long> relatedLocks = new HashSet<Long>();
        for (ShowLocksResponseElement lock2 : locksResponse.getLocks()) {
            if (!ci.dbname.equals(lock2.getDbname()) || (ci.tableName != null || lock2.getTablename() != null) && (ci.tableName == null || !ci.tableName.equals(lock2.getTablename())) || (ci.partName != null || lock2.getPartname() != null) && (ci.partName == null || !ci.partName.equals(lock2.getPartname()))) continue;
            relatedLocks.add(lock2.getLockid());
        }
        return relatedLocks;
    }

    private Set<Long> buildCurrentLockSet(ShowLocksResponse locksResponse) {
        HashSet<Long> currentLocks = new HashSet<Long>(locksResponse.getLocks().size());
        for (ShowLocksResponseElement lock2 : locksResponse.getLocks()) {
            currentLocks.add(lock2.getLockid());
        }
        return currentLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(CompactionInfo ci) throws MetaException {
        LOG.info("Starting cleaning for " + ci.getFullPartitionName());
        try {
            Table t = this.resolveTable(ci);
            if (t == null) {
                LOG.info("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped");
                return;
            }
            Partition p = null;
            if (ci.partName != null && (p = this.resolvePartition(ci)) == null) {
                LOG.info("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped");
                return;
            }
            StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
            final String location = sd.getLocation();
            final ValidReadTxnList txnList = new ValidReadTxnList();
            if (this.runJobAsSelf(ci.runAs)) {
                this.removeFiles(location, txnList);
            } else {
                LOG.info("Cleaning as user " + ci.runAs);
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Cleaner.this.removeFiles(location, txnList);
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception when cleaning, unable to complete cleaning " + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            this.txnHandler.markCleaned(ci);
        }
    }

    private void removeFiles(String location, ValidTxnList txnList) throws IOException {
        AcidUtils.Directory dir = AcidUtils.getAcidState(new Path(location), this.conf, txnList);
        List<FileStatus> obsoleteDirs = dir.getObsolete();
        ArrayList<Path> filesToDelete = new ArrayList<Path>(obsoleteDirs.size());
        for (FileStatus stat : obsoleteDirs) {
            filesToDelete.add(stat.getPath());
        }
        if (filesToDelete.size() < 1) {
            LOG.warn("Hmm, nothing to delete in the cleaner for directory " + location + ", that hardly seems right.");
            return;
        }
        FileSystem fs = ((Path)filesToDelete.get(0)).getFileSystem((Configuration)this.conf);
        for (Path dead : filesToDelete) {
            LOG.debug("Doing to delete path " + dead.toString());
            fs.delete(dead, true);
        }
    }
}

