/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;

@InterfaceAudience.Public
public class RetryingMetaStoreClient
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(RetryingMetaStoreClient.class.getName());
    private final IMetaStoreClient base;
    private final int retryLimit;
    private final long retryDelaySeconds;
    private final Map<String, Long> metaCallTimeMap;
    private final long connectionLifeTimeInMillis;
    private long lastConnectionTime;
    private boolean localMetaStore;

    protected RetryingMetaStoreClient(HiveConf hiveConf, HiveMetaHookLoader hookLoader, Map<String, Long> metaCallTimeMap, Class<? extends IMetaStoreClient> msClientClass) throws MetaException {
        this(hiveConf, new Class[]{HiveConf.class, HiveMetaHookLoader.class}, new Object[]{hiveConf, hookLoader}, metaCallTimeMap, msClientClass);
    }

    protected RetryingMetaStoreClient(HiveConf hiveConf, Class<?>[] constructorArgTypes, Object[] constructorArgs, Map<String, Long> metaCallTimeMap, Class<? extends IMetaStoreClient> msClientClass) throws MetaException {
        this.retryLimit = hiveConf.getIntVar(HiveConf.ConfVars.METASTORETHRIFTFAILURERETRIES);
        this.retryDelaySeconds = hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
        this.metaCallTimeMap = metaCallTimeMap;
        this.connectionLifeTimeInMillis = hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_LIFETIME, TimeUnit.SECONDS) * 1000L;
        this.lastConnectionTime = System.currentTimeMillis();
        String msUri = hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
        this.localMetaStore = msUri == null || msUri.trim().isEmpty();
        this.reloginExpiringKeytabUser();
        this.base = MetaStoreUtils.newInstance(msClientClass, constructorArgTypes, constructorArgs);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, new Class[]{HiveConf.class}, new Object[]{hiveConf}, null, HiveMetaStoreClient.class.getName());
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, HiveMetaHookLoader hookLoader, String mscClassName) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, hookLoader, null, mscClassName);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, HiveMetaHookLoader hookLoader, Map<String, Long> metaCallTimeMap, String mscClassName) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, new Class[]{HiveConf.class, HiveMetaHookLoader.class}, new Object[]{hiveConf, hookLoader}, metaCallTimeMap, mscClassName);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, Class<?>[] constructorArgTypes, Object[] constructorArgs, String mscClassName) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, constructorArgTypes, constructorArgs, null, mscClassName);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, Class<?>[] constructorArgTypes, Object[] constructorArgs, Map<String, Long> metaCallTimeMap, String mscClassName) throws MetaException {
        Class<?> baseClass = MetaStoreUtils.getClass(mscClassName);
        RetryingMetaStoreClient handler = new RetryingMetaStoreClient(hiveConf, constructorArgTypes, constructorArgs, metaCallTimeMap, baseClass);
        return (IMetaStoreClient)Proxy.newProxyInstance(RetryingMetaStoreClient.class.getClassLoader(), baseClass.getInterfaces(), (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        int retriesMade = 0;
        TException caughtException = null;
        while (true) {
            try {
                this.reloginExpiringKeytabUser();
                if (retriesMade > 0 || this.hasConnectionLifeTimeReached(method)) {
                    this.base.reconnect();
                    this.lastConnectionTime = System.currentTimeMillis();
                }
                if (this.metaCallTimeMap == null) {
                    ret = method.invoke((Object)this.base, args);
                    break;
                }
                long startTime = System.currentTimeMillis();
                ret = method.invoke((Object)this.base, args);
                long timeTaken = System.currentTimeMillis() - startTime;
                this.addMethodTime(method, timeTaken);
                break;
            }
            catch (UndeclaredThrowableException e) {
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof TApplicationException || e.getCause() instanceof TProtocolException || e.getCause() instanceof TTransportException) {
                    caughtException = (TException)e.getCause();
                }
                if (e.getCause() instanceof MetaException && e.getCause().getMessage().matches("(?s).*(JDO[a-zA-Z]*|TApplication|TProtocol|TTransport)Exception.*")) {
                    caughtException = (MetaException)((Object)e.getCause());
                }
                throw e.getCause();
            }
            catch (MetaException e) {
                if (e.getMessage().matches("(?s).*(IO|TTransport)Exception.*")) {
                    // empty if block
                }
                caughtException = e;
            }
            if (retriesMade >= this.retryLimit) {
                throw caughtException;
            }
            ++retriesMade;
            LOG.warn("MetaStoreClient lost connection. Attempting to reconnect.", caughtException);
            Thread.sleep(this.retryDelaySeconds * 1000L);
        }
        return ret;
    }

    private void addMethodTime(Method method, long timeTaken) {
        String methodStr = this.getMethodString(method);
        Long curTime = this.metaCallTimeMap.get(methodStr);
        if (curTime != null) {
            timeTaken += curTime.longValue();
        }
        this.metaCallTimeMap.put(methodStr, timeTaken);
    }

    private String getMethodString(Method method) {
        StringBuilder methodSb = new StringBuilder(method.getName());
        methodSb.append("_(");
        for (Class<?> paramClass : method.getParameterTypes()) {
            methodSb.append(paramClass.getSimpleName());
            methodSb.append(", ");
        }
        methodSb.append(")");
        return methodSb.toString();
    }

    private boolean hasConnectionLifeTimeReached(Method method) {
        boolean shouldReconnect;
        if (this.connectionLifeTimeInMillis <= 0L || this.localMetaStore || method.getName().equalsIgnoreCase("close")) {
            return false;
        }
        boolean bl = shouldReconnect = System.currentTimeMillis() - this.lastConnectionTime >= this.connectionLifeTimeInMillis;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reconnection status for Method: " + method.getName() + " is " + shouldReconnect);
        }
        return shouldReconnect;
    }

    private void reloginExpiringKeytabUser() throws MetaException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            if (ugi.isFromKeytab()) {
                ugi.checkTGTAndReloginFromKeytab();
            }
        }
        catch (IOException e) {
            String msg = "Error doing relogin using keytab " + e.getMessage();
            LOG.error(msg, e);
            throw new MetaException(msg);
        }
    }
}

