/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUnaryUDF;
import org.apache.hadoop.io.Text;

public class VectorUDFDateString
extends StringUnaryUDF {
    private static final long serialVersionUID = 1L;
    private static transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log LOG = LogFactory.getLog(VectorUDFDateString.class.getName());

    public VectorUDFDateString(int colNum, int outputColumn) {
        super(colNum, outputColumn, new StringUnaryUDF.IUDFUnaryString(){
            Text t = new Text();

            @Override
            public Text evaluate(Text s) {
                if (s == null) {
                    return null;
                }
                try {
                    Date date = formatter.parse(s.toString());
                    this.t.set(formatter.format(date));
                    return this.t;
                }
                catch (ParseException e) {
                    return null;
                }
            }
        });
    }

    public VectorUDFDateString() {
    }
}

