/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.mapred.Reporter;

public class CounterStatsPublisher
implements StatsPublisher,
StatsCollectionTaskIndependent {
    private static final Log LOG = LogFactory.getLog(CounterStatsPublisher.class.getName());
    private Reporter reporter;

    @Override
    public boolean init(Configuration hconf) {
        return true;
    }

    @Override
    public boolean connect(Configuration hconf) {
        MapredContext context = MapredContext.get();
        if (context == null || context.getReporter() == null) {
            return false;
        }
        this.reporter = context.getReporter();
        return true;
    }

    @Override
    public boolean publishStat(String fileID, Map<String, String> stats) {
        for (Map.Entry<String, String> entry : stats.entrySet()) {
            try {
                this.reporter.incrCounter(fileID, entry.getKey(), Long.valueOf(entry.getValue()).longValue());
            }
            catch (Exception e) {
                LOG.error("Failed to increment counter value " + entry.getValue() + " for " + entry.getKey() + ": " + e, e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean closeConnection() {
        return true;
    }
}

