/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.PartInfo;

public class HCatSplit
extends InputSplit
implements Writable,
org.apache.hadoop.mapred.InputSplit {
    private static final Logger LOG = LoggerFactory.getLogger(HCatSplit.class);
    private PartInfo partitionInfo;
    private org.apache.hadoop.mapred.InputSplit baseMapRedSplit;

    public HCatSplit() {
    }

    public HCatSplit(PartInfo partitionInfo, org.apache.hadoop.mapred.InputSplit baseMapRedSplit) {
        this.partitionInfo = partitionInfo;
        this.baseMapRedSplit = baseMapRedSplit;
    }

    public PartInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public org.apache.hadoop.mapred.InputSplit getBaseSplit() {
        return this.baseMapRedSplit;
    }

    public HCatSchema getDataSchema() {
        return this.partitionInfo.getPartitionSchema();
    }

    public HCatSchema getTableSchema() {
        assert (this.partitionInfo.getTableInfo() != null) : "TableInfo should have been set at this point.";
        return this.partitionInfo.getTableInfo().getAllColumns();
    }

    public long getLength() {
        try {
            return this.baseMapRedSplit.getLength();
        }
        catch (IOException e) {
            LOG.warn("Exception in HCatSplit", e);
            return 0L;
        }
    }

    public String[] getLocations() {
        try {
            return this.baseMapRedSplit.getLocations();
        }
        catch (IOException e) {
            LOG.warn("Exception in HCatSplit", e);
            return new String[0];
        }
    }

    public void readFields(DataInput input) throws IOException {
        String partitionInfoString = WritableUtils.readString((DataInput)input);
        this.partitionInfo = (PartInfo)HCatUtil.deserialize(partitionInfoString);
        String baseSplitClassName = WritableUtils.readString((DataInput)input);
        try {
            Class splitClass = JavaUtils.loadClass(baseSplitClassName);
            Constructor constructor = splitClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            org.apache.hadoop.mapred.InputSplit split = (org.apache.hadoop.mapred.InputSplit)constructor.newInstance(new Object[0]);
            split.readFields(input);
            this.baseMapRedSplit = split;
        }
        catch (Exception e) {
            throw new IOException("Exception from " + baseSplitClassName, e);
        }
    }

    public void write(DataOutput output) throws IOException {
        String partitionInfoString = HCatUtil.serialize(this.partitionInfo);
        WritableUtils.writeString((DataOutput)output, (String)partitionInfoString);
        WritableUtils.writeString((DataOutput)output, (String)this.baseMapRedSplit.getClass().getName());
        org.apache.hadoop.mapred.InputSplit baseSplitWritable = this.baseMapRedSplit;
        baseSplitWritable.write(output);
    }
}

