/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.conf;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import javax.inject.Inject;

public final class AccumuloSessionProperties {
    private static final String OPTIMIZE_LOCALITY_ENABLED = "optimize_locality_enabled";
    private static final String OPTIMIZE_SPLIT_RANGES_ENABLED = "optimize_split_ranges_enabled";
    private static final String OPTIMIZE_INDEX_ENABLED = "optimize_index_enabled";
    private static final String INDEX_ROWS_PER_SPLIT = "index_rows_per_split";
    private static final String INDEX_THRESHOLD = "index_threshold";
    private static final String INDEX_LOWEST_CARDINALITY_THRESHOLD = "index_lowest_cardinality_threshold";
    private static final String INDEX_METRICS_ENABLED = "index_metrics_enabled";
    private static final String SCAN_USERNAME = "scan_username";
    private static final String INDEX_SHORT_CIRCUIT_CARDINALITY_FETCH = "index_short_circuit_cardinality_fetch";
    private static final String INDEX_CARDINALITY_CACHE_POLLING_DURATION = "index_cardinality_cache_polling_duration";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public AccumuloSessionProperties() {
        PropertyMetadata s1 = PropertyMetadata.booleanProperty((String)OPTIMIZE_LOCALITY_ENABLED, (String)"Set to true to enable data locality for non-indexed scans. Default true.", (Boolean)true, (boolean)false);
        PropertyMetadata s2 = PropertyMetadata.booleanProperty((String)OPTIMIZE_SPLIT_RANGES_ENABLED, (String)"Set to true to split non-indexed queries by tablet splits. Should generally be true.", (Boolean)true, (boolean)false);
        PropertyMetadata s3 = PropertyMetadata.stringProperty((String)SCAN_USERNAME, (String)"User to impersonate when scanning the tables. This property trumps the scan_auths table property. Default is the user in the configuration file.", null, (boolean)false);
        PropertyMetadata s4 = PropertyMetadata.booleanProperty((String)OPTIMIZE_INDEX_ENABLED, (String)"Set to true to enable usage of the secondary index on query. Default true.", (Boolean)true, (boolean)false);
        PropertyMetadata s5 = PropertyMetadata.integerProperty((String)INDEX_ROWS_PER_SPLIT, (String)"The number of Accumulo row IDs that are packed into a single Presto split. Default 10000", (Integer)10000, (boolean)false);
        PropertyMetadata s6 = PropertyMetadata.doubleProperty((String)INDEX_THRESHOLD, (String)"The ratio between number of rows to be scanned based on the index over the total number of rows. If the ratio is below this threshold, the index will be used. Default .2", (Double)0.2, (boolean)false);
        PropertyMetadata s7 = PropertyMetadata.doubleProperty((String)INDEX_LOWEST_CARDINALITY_THRESHOLD, (String)"The threshold where the column with the lowest cardinality will be used instead of computing an intersection of ranges in the secondary index. Secondary index must be enabled. Default .01", (Double)0.01, (boolean)false);
        PropertyMetadata s8 = PropertyMetadata.booleanProperty((String)INDEX_METRICS_ENABLED, (String)"Set to true to enable usage of the metrics table to optimize usage of the index. Default true", (Boolean)true, (boolean)false);
        PropertyMetadata s9 = PropertyMetadata.booleanProperty((String)INDEX_SHORT_CIRCUIT_CARDINALITY_FETCH, (String)"Short circuit the retrieval of index metrics once any column is less than the lowest cardinality threshold. Default true", (Boolean)true, (boolean)false);
        PropertyMetadata s10 = new PropertyMetadata(INDEX_CARDINALITY_CACHE_POLLING_DURATION, "Sets the cardinality cache polling duration for short circuit retrieval of index metrics. Default 10ms", (Type)VarcharType.VARCHAR, String.class, (Object)"10ms", false, duration -> Duration.valueOf((String)duration.toString()).toString(), object -> object);
        this.sessionProperties = ImmutableList.of((Object)s1, (Object)s2, (Object)s3, (Object)s4, (Object)s5, (Object)s6, (Object)s7, (Object)s8, (Object)s9, (Object)s10);
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isOptimizeLocalityEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(OPTIMIZE_LOCALITY_ENABLED, Boolean.class);
    }

    public static boolean isOptimizeSplitRangesEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(OPTIMIZE_SPLIT_RANGES_ENABLED, Boolean.class);
    }

    public static boolean isOptimizeIndexEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(OPTIMIZE_INDEX_ENABLED, Boolean.class);
    }

    public static double getIndexThreshold(ConnectorSession session) {
        return (Double)session.getProperty(INDEX_THRESHOLD, Double.class);
    }

    public static int getNumIndexRowsPerSplit(ConnectorSession session) {
        return (Integer)session.getProperty(INDEX_ROWS_PER_SPLIT, Integer.class);
    }

    public static double getIndexSmallCardThreshold(ConnectorSession session) {
        return (Double)session.getProperty(INDEX_LOWEST_CARDINALITY_THRESHOLD, Double.class);
    }

    public static Duration getIndexCardinalityCachePollingDuration(ConnectorSession session) {
        return Duration.valueOf((String)((String)session.getProperty(INDEX_CARDINALITY_CACHE_POLLING_DURATION, String.class)));
    }

    public static boolean isIndexMetricsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(INDEX_METRICS_ENABLED, Boolean.class);
    }

    public static String getScanUsername(ConnectorSession session) {
        return (String)session.getProperty(SCAN_USERNAME, String.class);
    }

    public static boolean isIndexShortCircuitEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(INDEX_SHORT_CIRCUIT_CARDINALITY_FETCH, Boolean.class);
    }
}

