/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.model;

import com.facebook.presto.accumulo.Types;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Field {
    private final Object value;
    private final Type type;
    private final boolean indexed;

    public Field(Object value, Type type) {
        this(value, type, false);
    }

    public Field(Object value, Type type, boolean indexed) {
        this.value = Field.cleanObject(value, type);
        this.type = Objects.requireNonNull(type, "type is null");
        this.indexed = indexed;
    }

    public Field(Field field) {
        this.type = field.type;
        this.indexed = false;
        if (Types.isArrayType(this.type) || Types.isMapType(this.type)) {
            this.value = field.value;
            return;
        }
        if (this.type.equals(BigintType.BIGINT)) {
            this.value = field.getLong();
        } else if (this.type.equals(BooleanType.BOOLEAN)) {
            this.value = field.getBoolean();
        } else if (this.type.equals(DateType.DATE)) {
            this.value = new Date(field.getDate().getTime());
        } else if (this.type.equals(DoubleType.DOUBLE)) {
            this.value = field.getDouble();
        } else if (this.type.equals(IntegerType.INTEGER)) {
            this.value = field.getInt();
        } else if (this.type.equals(RealType.REAL)) {
            this.value = field.getFloat();
        } else if (this.type.equals(SmallintType.SMALLINT)) {
            this.value = field.getShort();
        } else if (this.type.equals(TimeType.TIME)) {
            this.value = new Time(field.getTime().getTime());
        } else if (this.type.equals(TimestampType.TIMESTAMP)) {
            this.value = new Timestamp(field.getTimestamp().getTime());
        } else if (this.type.equals(TinyintType.TINYINT)) {
            this.value = field.getByte();
        } else if (this.type.equals(VarbinaryType.VARBINARY)) {
            this.value = Arrays.copyOf(field.getVarbinary(), field.getVarbinary().length);
        } else if (this.type.equals(VarcharType.VARCHAR)) {
            this.value = field.getVarchar();
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type " + this.type);
        }
    }

    public Type getType() {
        return this.type;
    }

    public Block getArray() {
        return (Block)this.value;
    }

    public Long getLong() {
        return (Long)this.value;
    }

    public Boolean getBoolean() {
        return (Boolean)this.value;
    }

    public Byte getByte() {
        return (Byte)this.value;
    }

    public Date getDate() {
        return (Date)this.value;
    }

    public Double getDouble() {
        return (Double)this.value;
    }

    public Float getFloat() {
        return (Float)this.value;
    }

    public Integer getInt() {
        return (Integer)this.value;
    }

    public Block getMap() {
        return (Block)this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public Short getShort() {
        return (Short)this.value;
    }

    public Timestamp getTimestamp() {
        return (Timestamp)this.value;
    }

    public Time getTime() {
        return (Time)this.value;
    }

    public byte[] getVarbinary() {
        return (byte[])this.value;
    }

    public String getVarchar() {
        return (String)this.value;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type, this.indexed);
    }

    public boolean equals(Object obj) {
        Field field;
        boolean retval = true;
        if (obj instanceof Field && this.type.equals((field = (Field)obj).getType())) {
            retval = this.isNull() && field.isNull() ? true : (this.isNull() != field.isNull() ? false : (this.type.equals(VarbinaryType.VARBINARY) ? Arrays.equals((byte[])this.value, (byte[])field.getObject()) : (this.type.equals(DateType.DATE) || this.type.equals(TimeType.TIME) || this.type.equals(TimestampType.TIMESTAMP) ? this.value.toString().equals(field.getObject().toString()) : (this.value instanceof Block ? Field.equals((Block)this.value, (Block)field.getObject()) : this.value.equals(field.getObject())))));
        }
        return retval;
    }

    private static boolean equals(Block block1, Block block2) {
        boolean retval = block1.getPositionCount() == block2.getPositionCount();
        for (int i = 0; i < block1.getPositionCount() && retval; ++i) {
            retval = block1 instanceof ArrayBlock && block2 instanceof ArrayBlock ? Field.equals(block1.getBlock(i), block2.getBlock(i)) : block1.compareTo(i, 0, block1.getSliceLength(i), block2, i, 0, block2.getSliceLength(i)) == 0;
        }
        return retval;
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (Types.isArrayType(this.type)) {
            Type elementType = Types.getElementType(this.type);
            StringBuilder builder = new StringBuilder("ARRAY [");
            for (Object element : AccumuloRowSerializer.getArrayFromBlock(elementType, this.getArray())) {
                if (Types.isArrayType(elementType)) {
                    Type elementElementType = Types.getElementType(elementType);
                    builder.append(new Field(AccumuloRowSerializer.getBlockFromArray(elementElementType, (List)element), elementType)).append(',');
                    continue;
                }
                if (Types.isMapType(elementType)) {
                    builder.append(new Field(AccumuloRowSerializer.getBlockFromMap(elementType, (Map)element), elementType)).append(',');
                    continue;
                }
                builder.append(new Field(element, elementType)).append(',');
            }
            return builder.deleteCharAt(builder.length() - 1).append("]").toString();
        }
        if (Types.isMapType(this.type)) {
            StringBuilder builder = new StringBuilder("MAP(");
            StringBuilder keys = new StringBuilder("ARRAY [");
            StringBuilder values = new StringBuilder("ARRAY [");
            for (Map.Entry<Object, Object> entry : AccumuloRowSerializer.getMapFromBlock(this.type, this.getMap()).entrySet()) {
                Type keyType = Types.getKeyType(this.type);
                if (Types.isArrayType(keyType)) {
                    keys.append(new Field(AccumuloRowSerializer.getBlockFromArray(Types.getElementType(keyType), (List)entry.getKey()), keyType)).append(',');
                } else if (Types.isMapType(keyType)) {
                    keys.append(new Field(AccumuloRowSerializer.getBlockFromMap(keyType, (Map)entry.getKey()), keyType)).append(',');
                } else {
                    keys.append(new Field(entry.getKey(), keyType)).append(',');
                }
                Type valueType = Types.getValueType(this.type);
                if (Types.isArrayType(valueType)) {
                    values.append(new Field(AccumuloRowSerializer.getBlockFromArray(Types.getElementType(valueType), (List)entry.getValue()), valueType)).append(',');
                    continue;
                }
                if (Types.isMapType(valueType)) {
                    values.append(new Field(AccumuloRowSerializer.getBlockFromMap(valueType, (Map)entry.getValue()), valueType)).append(',');
                    continue;
                }
                values.append(new Field(entry.getValue(), valueType)).append(',');
            }
            keys.deleteCharAt(keys.length() - 1).append(']');
            values.deleteCharAt(values.length() - 1).append(']');
            return builder.append((CharSequence)keys).append(", ").append((CharSequence)values).append(")").toString();
        }
        if (this.type.equals(BigintType.BIGINT) || this.type.equals(BooleanType.BOOLEAN) || this.type.equals(DoubleType.DOUBLE) || this.type.equals(IntegerType.INTEGER) || this.type.equals(RealType.REAL) || this.type.equals(TinyintType.TINYINT) || this.type.equals(SmallintType.SMALLINT)) {
            return this.value.toString();
        }
        if (this.type.equals(DateType.DATE)) {
            return "DATE '" + this.value.toString() + "'";
        }
        if (this.type.equals(TimeType.TIME)) {
            return "TIME '" + this.value.toString() + "'";
        }
        if (this.type.equals(TimestampType.TIMESTAMP)) {
            return "TIMESTAMP '" + this.value.toString() + "'";
        }
        if (this.type.equals(VarbinaryType.VARBINARY)) {
            return "CAST('" + new String((byte[])this.value, StandardCharsets.UTF_8).replaceAll("'", "''") + "' AS VARBINARY)";
        }
        if (this.type instanceof VarcharType) {
            return "'" + this.value.toString().replaceAll("'", "''") + "'";
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported PrestoType " + this.type);
    }

    private static Object cleanObject(Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (Types.isArrayType(type)) {
            if (!(value instanceof Block)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Block, but " + value.getClass());
            }
            return value;
        }
        if (Types.isMapType(type)) {
            if (!(value instanceof Block)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Block, but " + value.getClass());
            }
            return value;
        }
        if (type.equals(BigintType.BIGINT)) {
            if (!(value instanceof Long)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Long, but " + value.getClass());
            }
        } else if (type.equals(IntegerType.INTEGER)) {
            if (value instanceof Long) {
                return ((Long)value).intValue();
            }
            if (!(value instanceof Integer)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Long or Integer, but " + value.getClass());
            }
        } else {
            if (type.equals(BooleanType.BOOLEAN)) {
                if (!(value instanceof Boolean)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Boolean, but " + value.getClass());
                }
                return value;
            }
            if (type.equals(DateType.DATE)) {
                if (value instanceof Long) {
                    return new Date(TimeUnit.DAYS.toMillis((Long)value));
                }
                if (value instanceof Calendar) {
                    return new Date(((Calendar)value).getTime().getTime());
                }
                if (!(value instanceof Date)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Calendar, Date, or Long, but " + value.getClass());
                }
            } else if (type.equals(DoubleType.DOUBLE)) {
                if (!(value instanceof Double)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Double, but " + value.getClass());
                }
            } else if (type.equals(RealType.REAL)) {
                if (value instanceof Long) {
                    return Float.valueOf(Float.intBitsToFloat(((Long)value).intValue()));
                }
                if (value instanceof Integer) {
                    return Float.valueOf(Float.intBitsToFloat((Integer)value));
                }
                if (!(value instanceof Float)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Float, but " + value.getClass());
                }
            } else if (type.equals(SmallintType.SMALLINT)) {
                if (value instanceof Long) {
                    return ((Long)value).shortValue();
                }
                if (value instanceof Integer) {
                    return ((Integer)value).shortValue();
                }
                if (!(value instanceof Short)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Short, but " + value.getClass());
                }
            } else if (type.equals(TimeType.TIME)) {
                if (value instanceof Long) {
                    return new Time((Long)value);
                }
                if (!(value instanceof Time)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Long or Time, but " + value.getClass());
                }
            } else if (type.equals(TimestampType.TIMESTAMP)) {
                if (value instanceof Long) {
                    return new Timestamp((Long)value);
                }
                if (!(value instanceof Timestamp)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Long or Timestamp, but " + value.getClass());
                }
            } else if (type.equals(TinyintType.TINYINT)) {
                if (value instanceof Long) {
                    return ((Long)value).byteValue();
                }
                if (value instanceof Integer) {
                    return ((Integer)value).byteValue();
                }
                if (value instanceof Short) {
                    return ((Short)value).byteValue();
                }
                if (!(value instanceof Byte)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Byte, but " + value.getClass());
                }
            } else if (type.equals(VarbinaryType.VARBINARY)) {
                if (value instanceof Slice) {
                    return ((Slice)value).getBytes();
                }
                if (!(value instanceof byte[])) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Slice byte[], but " + value.getClass());
                }
            } else if (type instanceof VarcharType) {
                if (value instanceof Slice) {
                    return new String(((Slice)value).getBytes(), StandardCharsets.UTF_8);
                }
                if (!(value instanceof String)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Object is not a Slice or String, but " + value.getClass());
                }
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported PrestoType " + type);
            }
        }
        return value;
    }
}

