/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.model;

import com.facebook.presto.accumulo.Types;
import com.facebook.presto.accumulo.model.Field;
import com.facebook.presto.accumulo.model.RowSchema;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class Row {
    private static final DateTimeFormatter DATE_PARSER = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter TIME_PARSER = DateTimeFormatter.ISO_LOCAL_TIME;
    private static final DateTimeFormatter TIMESTAMP_PARSER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final List<Field> fields = new ArrayList<Field>();

    public Row() {
    }

    public Row(Row row) {
        Objects.requireNonNull(row, "row is null");
        this.fields.addAll(row.fields.stream().map(Field::new).collect(Collectors.toList()));
    }

    public Row addField(Field field) {
        Objects.requireNonNull(field, "field is null");
        this.fields.add(field);
        return this;
    }

    public Row addField(Object value, Type type) {
        Objects.requireNonNull(type, "type is null");
        this.fields.add(new Field(value, type));
        return this;
    }

    public Field getField(int i) {
        return this.fields.get(i);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public int length() {
        return this.fields.size();
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields.toArray());
    }

    public boolean equals(Object obj) {
        return obj instanceof Row && Objects.equals(this.fields, ((Row)obj).getFields());
    }

    public String toString() {
        if (this.fields.isEmpty()) {
            return "()";
        }
        StringBuilder builder = new StringBuilder("(");
        for (Field f : this.fields) {
            builder.append(f).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.append(')').toString();
    }

    public static Row fromString(RowSchema schema, String str, char delimiter) {
        Row row = new Row();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList fields = builder.addAll(Splitter.on((char)delimiter).split((CharSequence)str)).build();
        if (fields.size() != schema.getLength()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Number of split tokens is not equal to schema length. Expected %s received %s. Schema: %s, fields {%s}, delimiter %s", schema.getLength(), fields.size(), schema, StringUtils.join((Collection)fields, (String)","), Character.valueOf(delimiter)));
        }
        for (int i = 0; i < fields.size(); ++i) {
            Type type = schema.getColumn(i).getType();
            row.addField(Row.valueFromString((String)fields.get(i), type), type);
        }
        return row;
    }

    public static Object valueFromString(String str, Type type) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        if (Types.isArrayType(type)) {
            Type elementType = Types.getElementType(type);
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (String element : Splitter.on((char)',').split((CharSequence)str)) {
                listBuilder.add(Row.valueFromString(element, elementType));
            }
            return AccumuloRowSerializer.getBlockFromArray(elementType, listBuilder.build());
        }
        if (Types.isMapType(type)) {
            Type keyType = Types.getKeyType(type);
            Type valueType = Types.getValueType(type);
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (String element : Splitter.on((char)',').split((CharSequence)str)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                ImmutableList keyValue = builder.addAll(Splitter.on((String)"->").split((CharSequence)element)).build();
                Preconditions.checkArgument((keyValue.size() == 2 ? 1 : 0) != 0, (Object)String.format("Map element %s has %d entries, not 2", element, keyValue.size()));
                mapBuilder.put(Row.valueFromString((String)keyValue.get(0), keyType), Row.valueFromString((String)keyValue.get(1), valueType));
            }
            return AccumuloRowSerializer.getBlockFromMap(type, mapBuilder.build());
        }
        if (type.equals(BigintType.BIGINT)) {
            return Long.parseLong(str);
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return Boolean.parseBoolean(str);
        }
        if (type.equals(DateType.DATE)) {
            return Date.valueOf(LocalDate.parse(str, DATE_PARSER));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return Double.parseDouble(str);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return Integer.parseInt(str);
        }
        if (type.equals(RealType.REAL)) {
            return Float.valueOf(Float.parseFloat(str));
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return Short.parseShort(str);
        }
        if (type.equals(TimeType.TIME)) {
            return Time.valueOf(LocalTime.parse(str, TIME_PARSER));
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return Timestamp.valueOf(LocalDateTime.parse(str, TIMESTAMP_PARSER));
        }
        if (type.equals(TinyintType.TINYINT)) {
            return Byte.valueOf(str);
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return str.getBytes(StandardCharsets.UTF_8);
        }
        if (type instanceof VarcharType) {
            return str;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type " + type);
    }
}

