/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.HeapIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.commons.lang.mutable.MutableLong;

public class LocalityGroupIterator
extends HeapIterator
implements InterruptibleIterator {
    private static final Collection<ByteSequence> EMPTY_CF_SET = Collections.emptySet();
    private LocalityGroup[] groups;
    private Set<ByteSequence> nonDefaultColumnFamilies;
    private AtomicBoolean interruptFlag;

    public LocalityGroupIterator(LocalityGroup[] groups, Set<ByteSequence> nonDefaultColumnFamilies) {
        super(groups.length);
        this.groups = groups;
        this.nonDefaultColumnFamilies = nonDefaultColumnFamilies;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static final int seek(HeapIterator hiter, LocalityGroup[] groups, Set<ByteSequence> nonDefaultColumnFamilies, Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        HashSet<ByteSequence> cfSet;
        hiter.clear();
        int numLGSeeked = 0;
        if (columnFamilies.size() > 0) {
            if (columnFamilies instanceof Set) {
                cfSet = (HashSet<ByteSequence>)columnFamilies;
            } else {
                cfSet = new HashSet<ByteSequence>();
                cfSet.addAll(columnFamilies);
            }
        } else {
            cfSet = Collections.emptySet();
        }
        for (LocalityGroup lgr : groups) {
            boolean include = false;
            if (cfSet.size() == 0) {
                include = !inclusive;
            } else if (lgr.isDefaultLocalityGroup && lgr.columnFamilies == null) {
                if (inclusive) {
                    if (!nonDefaultColumnFamilies.containsAll(cfSet)) {
                        include = true;
                    }
                } else {
                    include = true;
                }
            } else {
                for (Map.Entry<ByteSequence, MutableLong> entry : lgr.columnFamilies.entrySet()) {
                    if (entry.getValue().longValue() <= 0L) continue;
                    if (cfSet.contains(entry.getKey())) {
                        if (!inclusive) continue;
                        include = true;
                        continue;
                    }
                    if (inclusive) continue;
                    include = true;
                }
            }
            if (!include) continue;
            lgr.getIterator().seek(range, EMPTY_CF_SET, false);
            hiter.addSource(lgr.getIterator());
            ++numLGSeeked;
        }
        return numLGSeeked;
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        LocalityGroupIterator.seek(this, this.groups, this.nonDefaultColumnFamilies, range, columnFamilies, inclusive);
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        LocalityGroup[] groupsCopy = new LocalityGroup[this.groups.length];
        for (int i = 0; i < this.groups.length; ++i) {
            groupsCopy[i] = new LocalityGroup(this.groups[i], env);
            if (this.interruptFlag == null) continue;
            groupsCopy[i].getIterator().setInterruptFlag(this.interruptFlag);
        }
        return new LocalityGroupIterator(groupsCopy, this.nonDefaultColumnFamilies);
    }

    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        this.interruptFlag = flag;
        for (LocalityGroup lgr : this.groups) {
            lgr.getIterator().setInterruptFlag(flag);
        }
    }

    public static class LocalityGroup {
        protected boolean isDefaultLocalityGroup;
        protected Map<ByteSequence, MutableLong> columnFamilies;
        private InterruptibleIterator iterator;

        private LocalityGroup(LocalityGroup localityGroup, IteratorEnvironment env) {
            this(localityGroup.columnFamilies, localityGroup.isDefaultLocalityGroup);
            this.iterator = (InterruptibleIterator)localityGroup.iterator.deepCopy(env);
        }

        public LocalityGroup(InterruptibleIterator iterator, Map<ByteSequence, MutableLong> columnFamilies, boolean isDefaultLocalityGroup) {
            this(columnFamilies, isDefaultLocalityGroup);
            this.iterator = iterator;
        }

        public LocalityGroup(Map<ByteSequence, MutableLong> columnFamilies, boolean isDefaultLocalityGroup) {
            this.isDefaultLocalityGroup = isDefaultLocalityGroup;
            this.columnFamilies = columnFamilies;
        }

        public InterruptibleIterator getIterator() {
            return this.iterator;
        }
    }
}

