/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.accumulo.AccumuloClient;
import com.facebook.presto.accumulo.AccumuloConnector;
import com.facebook.presto.accumulo.AccumuloConnectorId;
import com.facebook.presto.accumulo.AccumuloErrorCode;
import com.facebook.presto.accumulo.AccumuloHandleResolver;
import com.facebook.presto.accumulo.AccumuloMetadata;
import com.facebook.presto.accumulo.AccumuloMetadataFactory;
import com.facebook.presto.accumulo.AccumuloSplitManager;
import com.facebook.presto.accumulo.AccumuloTableManager;
import com.facebook.presto.accumulo.conf.AccumuloConfig;
import com.facebook.presto.accumulo.conf.AccumuloSessionProperties;
import com.facebook.presto.accumulo.conf.AccumuloTableProperties;
import com.facebook.presto.accumulo.index.ColumnCardinalityCache;
import com.facebook.presto.accumulo.index.IndexLookup;
import com.facebook.presto.accumulo.io.AccumuloPageSinkProvider;
import com.facebook.presto.accumulo.io.AccumuloRecordSetProvider;
import com.facebook.presto.accumulo.metadata.AccumuloTable;
import com.facebook.presto.accumulo.metadata.ZooKeeperMetadataManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.log4j.Appender;
import org.apache.log4j.JulAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class AccumuloModule
implements Module {
    private final String connectorId;
    private final TypeManager typeManager;

    public AccumuloModule(String connectorId, TypeManager typeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        JulAppender appender = new JulAppender();
        appender.setLayout((Layout)new PatternLayout("%d %-5p %c - %m%n"));
        appender.setThreshold((Priority)Level.INFO);
        appender.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender((Appender)appender);
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(AccumuloConnector.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloConnectorId.class).toInstance((Object)new AccumuloConnectorId(this.connectorId));
        binder.bind(AccumuloMetadata.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloClient.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloHandleResolver.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(ZooKeeperMetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloTableManager.class).in(Scopes.SINGLETON);
        binder.bind(IndexLookup.class).in(Scopes.SINGLETON);
        binder.bind(ColumnCardinalityCache.class).in(Scopes.SINGLETON);
        binder.bind(Connector.class).toProvider(ConnectorProvider.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(AccumuloConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(AccumuloTable.class));
    }

    private static class ConnectorProvider
    implements Provider<Connector> {
        private static final Logger LOG = Logger.get(ConnectorProvider.class);
        private final String instance;
        private final String zooKeepers;
        private final String username;
        private final String password;

        @Inject
        public ConnectorProvider(AccumuloConfig config) {
            Objects.requireNonNull(config, "config is null");
            this.instance = config.getInstance();
            this.zooKeepers = config.getZooKeepers();
            this.username = config.getUsername();
            this.password = config.getPassword();
        }

        public Connector get() {
            try {
                ZooKeeperInstance inst = new ZooKeeperInstance(this.instance, this.zooKeepers);
                Connector connector = inst.getConnector(this.username, (AuthenticationToken)new PasswordToken(this.password.getBytes(StandardCharsets.UTF_8)));
                LOG.info("Connection to instance %s at %s established, user %s", new Object[]{this.instance, this.zooKeepers, this.username});
                return connector;
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to get connector to Accumulo", e);
            }
        }
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
        }
    }
}

