/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.iterators;

import com.google.common.primitives.UnsignedBytes;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;

public class MinByteArrayCombiner
extends Combiner {
    private final Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

    public Value reduce(Key key, Iterator<Value> iter) {
        Value min = null;
        while (iter.hasNext()) {
            Value test = iter.next();
            if (min == null) {
                min = new Value(test.get());
                continue;
            }
            if (this.comparator.compare(test.get(), min.get()) >= 0) continue;
            min.set(test.get());
        }
        return min;
    }
}

