/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.ConnectorImpl;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.CredentialProviderFactoryShim;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientContext {
    private static final Logger log = LoggerFactory.getLogger(ClientContext.class);
    protected final Instance inst;
    private Credentials creds;
    private ClientConfiguration clientConf;
    private final AccumuloConfiguration rpcConf;
    protected Connector conn;

    public ClientContext(Instance instance, Credentials credentials, ClientConfiguration clientConf) {
        this(instance, credentials, ClientContext.convertClientConfig((Configuration)Objects.requireNonNull(clientConf, "clientConf is null")));
        this.clientConf = clientConf;
    }

    public ClientContext(Instance instance, Credentials credentials, AccumuloConfiguration serverConf) {
        this.inst = Objects.requireNonNull(instance, "instance is null");
        this.creds = Objects.requireNonNull(credentials, "credentials is null");
        this.rpcConf = Objects.requireNonNull(serverConf, "serverConf is null");
        this.clientConf = null;
    }

    public Instance getInstance() {
        return this.inst;
    }

    public synchronized Credentials getCredentials() {
        return this.creds;
    }

    public synchronized void setCredentials(Credentials newCredentials) {
        Preconditions.checkArgument((newCredentials != null ? 1 : 0) != 0, (Object)"newCredentials is null");
        this.creds = newCredentials;
    }

    public AccumuloConfiguration getConfiguration() {
        return this.rpcConf;
    }

    public long getClientTimeoutInMillis() {
        return this.getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT);
    }

    public SslConnectionParams getClientSslParams() {
        return SslConnectionParams.forClient(this.getConfiguration());
    }

    public SaslConnectionParams getSaslParams() {
        boolean defaultVal = Boolean.parseBoolean(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED.getDefaultValue());
        if (null != this.clientConf) {
            if (!this.clientConf.getBoolean(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED.getKey(), defaultVal)) {
                return null;
            }
            return new SaslConnectionParams(this.clientConf, this.getCredentials().getToken());
        }
        AccumuloConfiguration conf = this.getConfiguration();
        if (!conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            return null;
        }
        return new SaslConnectionParams(conf, this.getCredentials().getToken());
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        if (this.conn == null) {
            if (this.getInstance() instanceof ZooKeeperInstance) {
                this.conn = new ConnectorImpl(this);
            } else {
                Credentials c = this.getCredentials();
                this.conn = this.getInstance().getConnector(c.getPrincipal(), c.getToken());
            }
        }
        return this.conn;
    }

    public TCredentials rpcCreds() {
        return this.getCredentials().toThrift(this.getInstance());
    }

    public static AccumuloConfiguration convertClientConfig(final Configuration config) {
        final DefaultConfiguration defaults = DefaultConfiguration.getInstance();
        return new AccumuloConfiguration(){

            @Override
            public String get(Property property) {
                org.apache.hadoop.conf.Configuration hadoopConf;
                String key = property.getKey();
                if (property.isSensitive() && null != (hadoopConf = this.getHadoopConfiguration())) {
                    try {
                        char[] value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key);
                        if (null != value) {
                            log.trace("Loaded sensitive value for {} from CredentialProvider", (Object)key);
                            return new String(value);
                        }
                        log.trace("Tried to load sensitive value for {} from CredentialProvider, but none was found", (Object)key);
                    }
                    catch (IOException e) {
                        log.warn("Failed to extract sensitive property ({}) from Hadoop CredentialProvider, falling back to base AccumuloConfiguration", (Object)key, (Object)e);
                    }
                }
                if (config.containsKey(key)) {
                    return config.getString(key);
                }
                if (Property.GENERAL_KERBEROS_PRINCIPAL == property && config.containsKey(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey())) {
                    return config.getString(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey()) + "/_HOST@" + SaslConnectionParams.getDefaultRealm();
                }
                return defaults.get(property);
            }

            @Override
            public void getProperties(Map<String, String> props, Predicate<String> filter) {
                org.apache.hadoop.conf.Configuration hadoopConf;
                defaults.getProperties(props, filter);
                Iterator keyIter = config.getKeys();
                while (keyIter.hasNext()) {
                    String key = keyIter.next().toString();
                    if (!filter.apply((Object)key)) continue;
                    props.put(key, config.getString(key));
                }
                if (props.containsKey(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey())) {
                    String serverPrimary = props.remove(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey());
                    if (filter.apply((Object)Property.GENERAL_KERBEROS_PRINCIPAL.getKey())) {
                        props.put(Property.GENERAL_KERBEROS_PRINCIPAL.getKey(), serverPrimary + "/_HOST@" + SaslConnectionParams.getDefaultRealm());
                    }
                }
                if (null != (hadoopConf = this.getHadoopConfiguration())) {
                    try {
                        for (String key : CredentialProviderFactoryShim.getKeys(hadoopConf)) {
                            char[] value;
                            if (!Property.isValidPropertyKey(key) || !Property.isSensitive(key) || !filter.apply((Object)key) || null == (value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key))) continue;
                            props.put(key, new String(value));
                        }
                    }
                    catch (IOException e) {
                        log.warn("Failed to extract sensitive properties from Hadoop CredentialProvider, falling back to accumulo-site.xml", (Throwable)e);
                    }
                }
            }

            private org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
                String credProviderPaths = config.getString(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey());
                if (null != credProviderPaths && !credProviderPaths.isEmpty()) {
                    org.apache.hadoop.conf.Configuration hadoopConf = new org.apache.hadoop.conf.Configuration();
                    hadoopConf.set("hadoop.security.credential.provider.path", credProviderPaths);
                    return hadoopConf;
                }
                log.trace("Did not find credential provider configuration in ClientConfiguration");
                return null;
            }
        };
    }
}

