/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import org.apache.accumulo.core.client.mapreduce.lib.impl.FileOutputConfigurator;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.log4j.Logger;

public class AccumuloFileOutputFormat
extends FileOutputFormat<Key, Value> {
    private static final Class<?> CLASS = AccumuloFileOutputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    @Deprecated
    protected static AccumuloConfiguration getAccumuloConfiguration(JobContext context) {
        return FileOutputConfigurator.getAccumuloConfiguration(CLASS, context.getConfiguration());
    }

    public static void setCompressionType(Job job, String compressionType) {
        FileOutputConfigurator.setCompressionType(CLASS, job.getConfiguration(), compressionType);
    }

    public static void setDataBlockSize(Job job, long dataBlockSize) {
        FileOutputConfigurator.setDataBlockSize(CLASS, job.getConfiguration(), dataBlockSize);
    }

    public static void setFileBlockSize(Job job, long fileBlockSize) {
        FileOutputConfigurator.setFileBlockSize(CLASS, job.getConfiguration(), fileBlockSize);
    }

    public static void setIndexBlockSize(Job job, long indexBlockSize) {
        FileOutputConfigurator.setIndexBlockSize(CLASS, job.getConfiguration(), indexBlockSize);
    }

    public static void setReplication(Job job, int replication) {
        FileOutputConfigurator.setReplication(CLASS, job.getConfiguration(), replication);
    }

    public RecordWriter<Key, Value> getRecordWriter(TaskAttemptContext context) throws IOException {
        final Configuration conf = context.getConfiguration();
        final AccumuloConfiguration acuConf = FileOutputConfigurator.getAccumuloConfiguration(CLASS, context.getConfiguration());
        String extension = acuConf.get(Property.TABLE_FILE_TYPE);
        final Path file = this.getDefaultWorkFile(context, "." + extension);
        final LRUMap validVisibilities = new LRUMap(1000);
        return new RecordWriter<Key, Value>(){
            FileSKVWriter out = null;

            public void close(TaskAttemptContext context) throws IOException {
                if (this.out != null) {
                    this.out.close();
                }
            }

            public void write(Key key, Value value) throws IOException {
                Boolean wasChecked = (Boolean)validVisibilities.get((Object)key.getColumnVisibilityData());
                if (wasChecked == null) {
                    byte[] cv = key.getColumnVisibilityData().toArray();
                    new ColumnVisibility(cv);
                    validVisibilities.put((Object)new ArrayByteSequence(Arrays.copyOf(cv, cv.length)), (Object)Boolean.TRUE);
                }
                if (this.out == null) {
                    this.out = FileOperations.getInstance().openWriter(file.toString(), file.getFileSystem(conf), conf, acuConf);
                    this.out.startDefaultLocalityGroup();
                }
                this.out.append(key, value);
            }
        };
    }
}

