/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.file.rfile.VisMetricsGatherer;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value=KeywordExecutable.class)
public class PrintInfo
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(PrintInfo.class);

    public static void main(String[] args) throws Exception {
        new PrintInfo().execute(args);
    }

    public String keyword() {
        return "rfile-info";
    }

    public void execute(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(PrintInfo.class.getName(), args, new Object[0]);
        if (opts.files.isEmpty()) {
            System.err.println("No files were given");
            System.exit(-1);
        }
        Configuration conf = new Configuration();
        for (String confFile : opts.configFiles) {
            log.debug("Adding Hadoop configuration file " + confFile);
            conf.addResource(new Path(confFile));
        }
        FileSystem hadoopFs = FileSystem.get((Configuration)conf);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        long[] countBuckets = new long[11];
        long[] sizeBuckets = new long[countBuckets.length];
        long totalSize = 0L;
        for (String arg : opts.files) {
            FileSystem fs;
            Path path = new Path(arg);
            if (arg.contains(":")) {
                fs = path.getFileSystem(conf);
            } else {
                log.warn("Attempting to find file across filesystems. Consider providing URI instead of path");
                fs = hadoopFs.exists(path) ? hadoopFs : localFs;
            }
            System.out.println("Reading file: " + path.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString());
            CachableBlockFile.Reader _rdr = new CachableBlockFile.Reader(fs, path, conf, null, null, (AccumuloConfiguration)SiteConfiguration.getInstance());
            RFile.Reader iter = new RFile.Reader(_rdr);
            VisMetricsGatherer vmg = new VisMetricsGatherer();
            if (opts.vis || opts.hash) {
                iter.registerMetrics(vmg);
            }
            iter.printInfo();
            System.out.println();
            org.apache.accumulo.core.file.rfile.bcfile.PrintInfo.main(new String[]{arg});
            Map<String, ArrayList<ByteSequence>> localityGroupCF = null;
            if (opts.histogram || opts.dump || opts.vis || opts.hash) {
                localityGroupCF = iter.getLocalityGroupCF();
                for (String lgName : localityGroupCF.keySet()) {
                    LocalityGroupUtil.seek(iter, new Range(), lgName, localityGroupCF);
                    while (iter.hasTop()) {
                        Key key = iter.getTopKey();
                        Value value = iter.getTopValue();
                        if (opts.dump) {
                            System.out.println(key + " -> " + value);
                        }
                        if (opts.histogram) {
                            int bucket;
                            long size = key.getSize() + value.getSize();
                            int n = bucket = (int)Math.log10(size);
                            countBuckets[n] = countBuckets[n] + 1L;
                            int n2 = bucket;
                            sizeBuckets[n2] = sizeBuckets[n2] + size;
                            totalSize += size;
                        }
                        iter.next();
                    }
                }
            }
            System.out.println();
            iter.close();
            if (opts.vis || opts.hash) {
                vmg.printMetrics(opts.hash, "Visibility", System.out);
            }
            if (opts.histogram) {
                System.out.println("Up to size      count      %-age");
                for (int i = 1; i < countBuckets.length; ++i) {
                    System.out.println(String.format("%11.0f : %10d %6.2f%%", Math.pow(10.0, i), countBuckets[i], (double)sizeBuckets[i] * 100.0 / (double)totalSize));
                }
            }
            if (!System.out.checkError()) continue;
            return;
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-d", "--dump"}, description="dump the key/value pairs")
        boolean dump = false;
        @Parameter(names={"-v", "--vis"}, description="show visibility metrics")
        boolean vis = false;
        @Parameter(names={"--visHash"}, description="show visibilities as hashes, implies -v")
        boolean hash = false;
        @Parameter(names={"--histogram"}, description="print a histogram of the key-value sizes")
        boolean histogram = false;
        @Parameter(description=" <file> { <file> ... }")
        List<String> files = new ArrayList<String>();
        @Parameter(names={"-c", "--config"}, variableArity=true, description="Comma-separated Hadoop configuration files")
        List<String> configFiles = new ArrayList<String>();

        Opts() {
        }
    }
}

