/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.start.spi.KeywordExecutable;

@AutoService(value=KeywordExecutable.class)
public class Jar
implements KeywordExecutable {
    public String keyword() {
        return "jar";
    }

    public void execute(String[] args) throws Exception {
        if (args.length == 0) {
            Main.printUsage();
            System.exit(1);
        }
        String jarFileName = args[0];
        String candidateMainClass = args.length > 1 ? args[1] : null;
        Class mainClass = null;
        try (JarFile f = new JarFile(jarFileName);){
            mainClass = Main.loadClassFromJar((String[])args, (JarFile)f, (ClassLoader)Main.getClassLoader());
        }
        catch (IOException ioe) {
            System.out.println("File " + jarFileName + " could not be found or read.");
            System.exit(1);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Classname " + (candidateMainClass != null ? candidateMainClass : "in JAR manifest") + " not found.  Please make sure you use the wholly qualified package name.");
            System.exit(1);
        }
        String[] newArgs = Main.stripArgs((String[])args, (int)(mainClass.getName().equals(candidateMainClass) ? 2 : 1));
        Main.execMainClass((Class)mainClass, (String[])newArgs);
    }
}

