/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.ServiceClient;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.SharedAccessPolicy;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.SharedAccessBlobHeaders;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.UriQueryBuilder;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.queue.SharedAccessQueuePolicy;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.SharedAccessTablePolicy;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SharedAccessSignatureHelper {
    public static UriQueryBuilder generateSharedAccessSignatureForBlob(SharedAccessBlobPolicy policy, SharedAccessBlobHeaders headers, String groupPolicyIdentifier, String resourceType, String signature) throws StorageException {
        Utility.assertNotNullOrEmpty("resourceType", resourceType);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, groupPolicyIdentifier, resourceType, null, signature, null, headers);
    }

    public static UriQueryBuilder generateSharedAccessSignatureForQueue(SharedAccessQueuePolicy policy, String groupPolicyIdentifier, String signature) throws StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, groupPolicyIdentifier, null, null, signature, null, null);
    }

    public static UriQueryBuilder generateSharedAccessSignatureForTable(SharedAccessTablePolicy policy, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, String accessPolicyIdentifier, String tableName, String signature, String accountKeyName) throws StorageException {
        Utility.assertNotNull("tableName", tableName);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, startPartitionKey, startRowKey, endPartitionKey, endRowKey, accessPolicyIdentifier, null, tableName, signature, accountKeyName, null);
    }

    public static String generateSharedAccessSignatureHashForBlob(SharedAccessBlobPolicy policy, SharedAccessBlobHeaders headers, String accessPolicyIdentifier, String resourceName, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForBlob((SharedAccessPolicy)policy, resourceName, accessPolicyIdentifier, client, opContext, headers);
    }

    public static String generateSharedAccessSignatureHashForQueue(SharedAccessQueuePolicy policy, String accessPolicyIdentifier, String resourceName, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForQueueAndTable(policy, resourceName, accessPolicyIdentifier, false, null, null, null, null, client, opContext);
    }

    public static String generateSharedAccessSignatureHashForTable(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String resourceName, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForQueueAndTable(policy, resourceName, accessPolicyIdentifier, true, startPartitionKey, startRowKey, endPartitionKey, endRowKey, client, opContext);
    }

    public static StorageCredentialsSharedAccessSignature parseQuery(HashMap<String, String[]> queryParams) throws StorageException {
        String signature = null;
        String signedStart = null;
        String signedExpiry = null;
        String signedResource = null;
        String signedPermissions = null;
        String signedIdentifier = null;
        String signedVersion = null;
        String cacheControl = null;
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentDisposition = null;
        String tableName = null;
        String startPk = null;
        String startRk = null;
        String endPk = null;
        String endRk = null;
        boolean sasParameterFound = false;
        StorageCredentialsSharedAccessSignature credentials = null;
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            String lowerKey = entry.getKey().toLowerCase(Utility.LOCALE_US);
            if (lowerKey.equals("st")) {
                signedStart = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("se")) {
                signedExpiry = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sp")) {
                signedPermissions = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sr")) {
                signedResource = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("si")) {
                signedIdentifier = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sig")) {
                signature = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sv")) {
                signedVersion = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rscc")) {
                cacheControl = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rsct")) {
                contentType = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rsce")) {
                contentEncoding = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rscl")) {
                contentLanguage = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rscd")) {
                contentDisposition = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("tn")) {
                tableName = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("spk")) {
                startPk = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("srk")) {
                startRk = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("epk")) {
                endPk = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (!lowerKey.equals("erk")) continue;
            endRk = entry.getValue()[0];
            sasParameterFound = true;
        }
        if (sasParameterFound) {
            if (signature == null) {
                String errorMessage = "Missing mandatory parameters for valid Shared Access Signature.";
                throw new IllegalArgumentException("Missing mandatory parameters for valid Shared Access Signature.");
            }
            UriQueryBuilder builder = new UriQueryBuilder();
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "st", signedStart);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "se", signedExpiry);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sp", signedPermissions);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sr", signedResource);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "si", signedIdentifier);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sv", signedVersion);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sig", signature);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscc", cacheControl);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rsct", contentType);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rsce", contentEncoding);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscl", contentLanguage);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscd", contentDisposition);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "tn", tableName);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "spk", startPk);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "srk", startRk);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "epk", endPk);
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "erk", endRk);
            String token = builder.toString();
            credentials = new StorageCredentialsSharedAccessSignature(token);
        }
        return credentials;
    }

    private static void addIfNotNullOrEmpty(UriQueryBuilder builder, String name, String val) throws StorageException {
        if (!Utility.isNullOrEmpty(val)) {
            builder.add(name, val);
        }
    }

    private static UriQueryBuilder generateSharedAccessSignatureHelper(SharedAccessPolicy policy, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, String accessPolicyIdentifier, String resourceType, String tableName, String signature, String accountKeyName, SharedAccessBlobHeaders headers) throws StorageException {
        Utility.assertNotNull("signature", signature);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("sv", "2014-02-14");
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sp", permissions);
        String startString = Utility.getUTCTimeOrEmpty(startTime);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "st", startString);
        String stopString = Utility.getUTCTimeOrEmpty(expiryTime);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "se", stopString);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "spk", startPartitionKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "srk", startRowKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "epk", endPartitionKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "erk", endRowKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "si", accessPolicyIdentifier);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sr", resourceType);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "tn", tableName);
        if (headers != null) {
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscc", headers.getCacheControl());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rsct", headers.getContentType());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rsce", headers.getContentEncoding());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscl", headers.getContentLanguage());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscd", headers.getContentDisposition());
        }
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sig", signature);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sk", accountKeyName);
        return builder;
    }

    private static String generateSharedAccessSignatureHashForBlob(SharedAccessPolicy policy, String resourceName, String accessPolicyIdentifier, ServiceClient client, OperationContext opContext, SharedAccessBlobHeaders headers) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resourceName", resourceName);
        Utility.assertNotNull("client", client);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        String cacheControl = null;
        String contentDisposition = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentType = null;
        if (headers != null) {
            cacheControl = headers.getCacheControl();
            contentDisposition = headers.getContentDisposition();
            contentEncoding = headers.getContentEncoding();
            contentLanguage = headers.getContentLanguage();
            contentType = headers.getContentType();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s", permissions == null ? "" : permissions, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), resourceName, accessPolicyIdentifier == null ? "" : accessPolicyIdentifier, "2014-02-14", cacheControl == null ? "" : cacheControl, contentDisposition == null ? "" : contentDisposition, contentEncoding == null ? "" : contentEncoding, contentLanguage == null ? "" : contentLanguage, contentType == null ? "" : contentType);
        stringToSign = Utility.safeDecode(stringToSign);
        String signature = StorageCredentialsHelper.computeHmac256(client.getCredentials(), stringToSign, opContext);
        return signature;
    }

    private static String generateSharedAccessSignatureHashForQueueAndTable(SharedAccessPolicy policy, String resourceName, String accessPolicyIdentifier, boolean useTableSas, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resourceName", resourceName);
        Utility.assertNotNull("client", client);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s", permissions == null ? "" : permissions, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), resourceName, accessPolicyIdentifier == null ? "" : accessPolicyIdentifier, "2014-02-14");
        if (useTableSas) {
            stringToSign = String.format("%s\n%s\n%s\n%s\n%s", stringToSign, startPartitionKey == null ? "" : startPartitionKey, startRowKey == null ? "" : startRowKey, endPartitionKey == null ? "" : endPartitionKey, endRowKey == null ? "" : endRowKey);
        }
        stringToSign = Utility.safeDecode(stringToSign);
        String signature = StorageCredentialsHelper.computeHmac256(client.getCredentials(), stringToSign, opContext);
        return signature;
    }

    private SharedAccessSignatureHelper() {
    }
}

