/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.security.Authorizations;

public class ConditionalWriterConfig {
    private static final Long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    private Long timeout = null;
    private static final Integer DEFAULT_MAX_WRITE_THREADS = 3;
    private Integer maxWriteThreads = null;
    private Authorizations auths = Authorizations.EMPTY;
    private Durability durability = Durability.DEFAULT;

    public ConditionalWriterConfig setAuthorizations(Authorizations auths) {
        Preconditions.checkArgument((auths != null ? 1 : 0) != 0, (Object)"auths is null");
        this.auths = auths;
        return this;
    }

    public ConditionalWriterConfig setTimeout(long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout not allowed " + timeout);
        }
        this.timeout = timeout == 0L ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(Math.max(1L, timeUnit.toMillis(timeout)));
        return this;
    }

    public ConditionalWriterConfig setMaxWriteThreads(int maxWriteThreads) {
        if (maxWriteThreads <= 0) {
            throw new IllegalArgumentException("Max threads must be positive " + maxWriteThreads);
        }
        this.maxWriteThreads = maxWriteThreads;
        return this;
    }

    public ConditionalWriterConfig setDurability(Durability durability) {
        this.durability = durability;
        return this;
    }

    public Authorizations getAuthorizations() {
        return this.auths;
    }

    public long getTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeout != null ? this.timeout : DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public int getMaxWriteThreads() {
        return this.maxWriteThreads != null ? this.maxWriteThreads : DEFAULT_MAX_WRITE_THREADS;
    }

    public Durability getDurability() {
        return this.durability;
    }
}

