/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterClient {
    private static final Logger log = LoggerFactory.getLogger(MasterClient.class);

    public static MasterClientService.Client getConnectionWithRetry(ClientContext context) {
        MasterClientService.Client result;
        while ((result = MasterClient.getConnection(context)) == null) {
            UtilWaitThread.sleep(250L);
        }
        return result;
    }

    public static MasterClientService.Client getConnection(ClientContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        List<String> locations = context.getInstance().getMasterLocations();
        if (locations.size() == 0) {
            log.debug("No masters...");
            return null;
        }
        HostAndPort master = HostAndPort.fromString(locations.get(0));
        if (0 == master.getPort()) {
            return null;
        }
        try {
            MasterClientService.Client client = ThriftUtil.getClientNoTimeout(new MasterClientService.Client.Factory(), master, context);
            return client;
        }
        catch (TTransportException tte) {
            Throwable cause = tte.getCause();
            if (null != cause && cause instanceof UnknownHostException) {
                throw new RuntimeException(tte);
            }
            log.debug("Failed to connect to master=" + master + ", will retry... ", (Throwable)tte);
            return null;
        }
    }

    public static void close(MasterClientService.Iface iface) {
        TServiceClient client = (TServiceClient)iface;
        if (client != null && client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
            ThriftTransportPool.getInstance().returnTransport(client.getInputProtocol().getTransport());
        } else {
            log.debug("Attempt to close null connection to the master", (Throwable)new Exception());
        }
    }

    public static <T> T execute(ClientContext context, ClientExecReturn<T, MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        MasterClientService.Client client = null;
        while (true) {
            try {
                client = MasterClient.getConnectionWithRetry(context);
                T t = exec.execute(client);
                return t;
            }
            catch (TTransportException tte) {
                log.debug("MasterClient request failed, retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (AccumuloException e) {
                throw e;
            }
            catch (ThriftTableOperationException e) {
                switch (e.getType()) {
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(e.getTableName(), new NamespaceNotFoundException(e));
                    }
                    case NOTFOUND: {
                        throw new TableNotFoundException(e);
                    }
                }
                throw new AccumuloException((Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client == null) continue;
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    public static void executeGeneric(ClientContext context, ClientExec<MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        MasterClientService.Client client = null;
        while (true) {
            try {
                client = MasterClient.getConnectionWithRetry(context);
                exec.execute(client);
            }
            catch (TTransportException tte) {
                log.debug("MasterClient request failed, retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (AccumuloException e) {
                throw e;
            }
            catch (ThriftTableOperationException e) {
                switch (e.getType()) {
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(e.getTableName(), new NamespaceNotFoundException(e));
                    }
                    case NOTFOUND: {
                        throw new TableNotFoundException(e);
                    }
                }
                throw new AccumuloException((Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client == null) continue;
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    public static void executeTable(ClientContext context, ClientExec<MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        MasterClient.executeGeneric(context, exec);
    }

    public static void executeNamespace(ClientContext context, ClientExec<MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        block2: {
            try {
                MasterClient.executeGeneric(context, exec);
            }
            catch (TableNotFoundException e) {
                if (!(e.getCause() instanceof NamespaceNotFoundException)) break block2;
                throw (NamespaceNotFoundException)e.getCause();
            }
        }
    }

    public static void execute(ClientContext context, ClientExec<MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            MasterClient.executeGeneric(context, exec);
        }
        catch (TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }
}

