/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.mock.IteratorAdapter;
import org.apache.accumulo.core.client.mock.MockScannerBase;
import org.apache.accumulo.core.client.mock.MockTable;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.SortedMapIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.collections.iterators.IteratorChain;

public class MockBatchScanner
extends MockScannerBase
implements BatchScanner {
    List<Range> ranges = null;

    public MockBatchScanner(MockTable mockTable, Authorizations authorizations) {
        super(mockTable, authorizations);
    }

    @Override
    public void setRanges(Collection<Range> ranges) {
        if (ranges == null || ranges.size() == 0) {
            throw new IllegalArgumentException("ranges must be non null and contain at least 1 range");
        }
        this.ranges = new ArrayList<Range>(ranges);
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        if (this.ranges == null) {
            throw new IllegalStateException("ranges not set");
        }
        IteratorChain chain = new IteratorChain();
        for (Range range : this.ranges) {
            SortedKeyValueIterator<Key, Value> i = new SortedMapIterator(this.table.table);
            try {
                i = this.createFilter(i);
                i.seek(range, MockBatchScanner.createColumnBSS(this.fetchedColumns), !this.fetchedColumns.isEmpty());
                chain.addIterator((Iterator)new IteratorAdapter(i));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return chain;
    }

    @Override
    public void close() {
    }
}

