/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.keyfunctor;

import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.keyfunctor.KeyFunctor;
import org.apache.hadoop.util.bloom.Key;

public class RowFunctor
implements KeyFunctor {
    @Override
    public Key transform(org.apache.accumulo.core.data.Key acuKey) {
        ByteSequence row = acuKey.getRowData();
        byte[] keyData = new byte[row.length()];
        System.arraycopy(row.getBackingArray(), 0, keyData, 0, row.length());
        return new Key(keyData, 1.0);
    }

    @Override
    public Key transform(Range range) {
        if (RowFunctor.isRangeInBloomFilter(range, PartialKey.ROW)) {
            return this.transform(range.getStartKey());
        }
        return null;
    }

    static boolean isRangeInBloomFilter(Range range, PartialKey keyDepth) {
        if (range.getStartKey() == null || range.getEndKey() == null) {
            return false;
        }
        if (range.getStartKey().equals(range.getEndKey(), keyDepth)) {
            return true;
        }
        return range.getStartKey().followingKey(keyDepth).equals(range.getEndKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME) && !range.isEndKeyInclusive();
    }
}

