/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.facebook.presto.hadoop.$internal.com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.VolumeFailureInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Time;

class FsVolumeList {
    private final AtomicReference<FsVolumeImpl[]> volumes = new AtomicReference<FsVolumeImpl[]>(new FsVolumeImpl[0]);
    private final Map<String, VolumeFailureInfo> volumeFailureInfos = Collections.synchronizedMap(new TreeMap());
    private Object checkDirsMutex = new Object();
    private final VolumeChoosingPolicy<FsVolumeImpl> blockChooser;
    private final BlockScanner blockScanner;

    FsVolumeList(List<VolumeFailureInfo> initialVolumeFailureInfos, BlockScanner blockScanner, VolumeChoosingPolicy<FsVolumeImpl> blockChooser) {
        this.blockChooser = blockChooser;
        this.blockScanner = blockScanner;
        for (VolumeFailureInfo volumeFailureInfo : initialVolumeFailureInfos) {
            this.volumeFailureInfos.put(volumeFailureInfo.getFailedStorageLocation(), volumeFailureInfo);
        }
    }

    List<FsVolumeImpl> getVolumes() {
        return Collections.unmodifiableList(Arrays.asList((Object[])this.volumes.get()));
    }

    private FsVolumeReference chooseVolume(List<FsVolumeImpl> list, long blockSize) throws IOException {
        while (true) {
            FsVolumeImpl volume = this.blockChooser.chooseVolume(list, blockSize);
            try {
                return volume.obtainReference();
            }
            catch (ClosedChannelException e) {
                FsDatasetImpl.LOG.warn("Chosen a closed volume: " + volume);
                list.remove(volume);
                continue;
            }
            break;
        }
    }

    FsVolumeReference getNextVolume(StorageType storageType, long blockSize) throws IOException {
        FsVolumeImpl[] curVolumes = this.volumes.get();
        ArrayList<FsVolumeImpl> list = new ArrayList<FsVolumeImpl>(curVolumes.length);
        for (FsVolumeImpl v : curVolumes) {
            if (v.getStorageType() != storageType) continue;
            list.add(v);
        }
        return this.chooseVolume(list, blockSize);
    }

    FsVolumeReference getNextTransientVolume(long blockSize) throws IOException {
        List<FsVolumeImpl> curVolumes = this.getVolumes();
        ArrayList<FsVolumeImpl> list = new ArrayList<FsVolumeImpl>(curVolumes.size());
        for (FsVolumeImpl v : curVolumes) {
            if (!v.isTransientStorage()) continue;
            list.add(v);
        }
        return this.chooseVolume(list, blockSize);
    }

    long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes.get()) {
            try (FsVolumeReference ref = v.obtainReference();){
                dfsUsed += v.getDfsUsed();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
        return dfsUsed;
    }

    long getBlockPoolUsed(String bpid) throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes.get()) {
            try (FsVolumeReference ref = v.obtainReference();){
                dfsUsed += v.getBlockPoolUsed(bpid);
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
        return dfsUsed;
    }

    long getCapacity() {
        long capacity = 0L;
        for (FsVolumeImpl v : this.volumes.get()) {
            try (FsVolumeReference ref = v.obtainReference();){
                capacity += v.getCapacity();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return capacity;
    }

    long getRemaining() throws IOException {
        long remaining = 0L;
        for (FsVolumeImpl vol : this.volumes.get()) {
            try (FsVolumeReference ref = vol.obtainReference();){
                remaining += vol.getAvailable();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
        return remaining;
    }

    void getAllVolumesMap(final String bpid, final ReplicaMap volumeMap, final RamDiskReplicaTracker ramDiskReplicaMap) throws IOException {
        long totalStartTime = Time.monotonicNow();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<1> replicaAddingThreads = new ArrayList<1>();
        for (final FsVolumeImpl v : this.volumes.get()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try (FsVolumeReference ref = v.obtainReference();){
                        FsDatasetImpl.LOG.info("Adding replicas to map for block pool " + bpid + " on volume " + v + "...");
                        long startTime = Time.monotonicNow();
                        v.getVolumeMap(bpid, volumeMap, ramDiskReplicaMap);
                        long timeTaken = Time.monotonicNow() - startTime;
                        FsDatasetImpl.LOG.info("Time to add replicas to map for block pool " + bpid + " on volume " + v + ": " + timeTaken + "ms");
                    }
                    catch (ClosedChannelException e) {
                        FsDatasetImpl.LOG.info("The volume " + v + " is closed while " + "addng replicas, ignored.");
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info("Caught exception while adding replicas from " + v + ". Will throw later.", ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            replicaAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : replicaAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = Time.monotonicNow() - totalStartTime;
        FsDatasetImpl.LOG.info("Total time to add all replicas to map: " + totalTimeTaken + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<File> checkDirs() {
        Object object = this.checkDirsMutex;
        synchronized (object) {
            HashSet<File> failedVols = null;
            List<FsVolumeImpl> volumeList = this.getVolumes();
            for (FsVolumeImpl fsv : volumeList) {
                try {
                    FsVolumeReference ref = fsv.obtainReference();
                    Throwable throwable = null;
                    try {
                        fsv.checkDirs();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ref == null) continue;
                        if (throwable != null) {
                            try {
                                ref.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ref.close();
                    }
                }
                catch (DiskChecker.DiskErrorException e) {
                    FsDatasetImpl.LOG.warn("Removing failed volume " + fsv + ": ", e);
                    if (failedVols == null) {
                        failedVols = new HashSet<File>(1);
                    }
                    failedVols.add(new File(fsv.getBasePath()).getAbsoluteFile());
                    this.addVolumeFailureInfo(fsv);
                    this.removeVolume(fsv);
                }
                catch (ClosedChannelException e) {
                    FsDatasetImpl.LOG.debug("Caught exception when obtaining reference count on closed volume", e);
                }
                catch (IOException e) {
                    FsDatasetImpl.LOG.error("Unexpected IOException", e);
                }
            }
            if (failedVols != null && failedVols.size() > 0) {
                FsDatasetImpl.LOG.warn("Completed checkDirs. Found " + failedVols.size() + " failure volumes.");
            }
            return failedVols;
        }
    }

    public String toString() {
        return Arrays.toString(this.volumes.get());
    }

    void addVolume(FsVolumeReference ref) {
        while (true) {
            FsVolumeImpl[] curVolumes = this.volumes.get();
            ArrayList<FsVolumeImpl> volumeList = Lists.newArrayList(curVolumes);
            volumeList.add((FsVolumeImpl)ref.getVolume());
            if (this.volumes.compareAndSet(curVolumes, volumeList.toArray(new FsVolumeImpl[volumeList.size()]))) break;
            if (!FsDatasetImpl.LOG.isDebugEnabled()) continue;
            FsDatasetImpl.LOG.debug("The volume list has been changed concurrently, retry to remove volume: " + ref.getVolume().getStorageID());
        }
        if (this.blockScanner != null) {
            this.blockScanner.addVolumeScanner(ref);
        } else {
            IOUtils.cleanup(FsDatasetImpl.LOG, ref);
        }
        this.removeVolumeFailureInfo(new File(ref.getVolume().getBasePath()));
        FsDatasetImpl.LOG.info("Added new volume: " + ref.getVolume().getStorageID());
    }

    private void removeVolume(FsVolumeImpl target) {
        block5: {
            FsVolumeImpl[] curVolumes;
            ArrayList<FsVolumeImpl> volumeList;
            while ((volumeList = Lists.newArrayList(curVolumes = this.volumes.get())).remove(target)) {
                if (this.volumes.compareAndSet(curVolumes, volumeList.toArray(new FsVolumeImpl[volumeList.size()]))) {
                    if (this.blockScanner != null) {
                        this.blockScanner.removeVolumeScanner(target);
                    }
                    try {
                        target.closeAndWait();
                    }
                    catch (IOException e) {
                        FsDatasetImpl.LOG.warn("Error occurs when waiting volume to close: " + target, e);
                    }
                    target.shutdown();
                    FsDatasetImpl.LOG.info("Removed volume: " + target);
                    break block5;
                }
                if (!FsDatasetImpl.LOG.isDebugEnabled()) continue;
                FsDatasetImpl.LOG.debug("The volume list has been changed concurrently, retry to remove volume: " + target);
            }
            if (!FsDatasetImpl.LOG.isDebugEnabled()) break block5;
            FsDatasetImpl.LOG.debug("Volume " + target + " does not exist or is removed by others.");
        }
    }

    void removeVolume(File volume, boolean clearFailure) {
        FsVolumeImpl[] curVolumes = this.volumes.get();
        ArrayList<FsVolumeImpl> volumeList = Lists.newArrayList(curVolumes);
        for (FsVolumeImpl fsVolume : volumeList) {
            String targetPath;
            String basePath = new File(fsVolume.getBasePath()).getAbsolutePath();
            if (!basePath.equals(targetPath = volume.getAbsolutePath())) continue;
            this.removeVolume(fsVolume);
        }
        if (clearFailure) {
            this.removeVolumeFailureInfo(volume);
        }
    }

    VolumeFailureInfo[] getVolumeFailureInfos() {
        Collection<VolumeFailureInfo> infos = this.volumeFailureInfos.values();
        return infos.toArray(new VolumeFailureInfo[infos.size()]);
    }

    void addVolumeFailureInfo(VolumeFailureInfo volumeFailureInfo) {
        this.volumeFailureInfos.put(volumeFailureInfo.getFailedStorageLocation(), volumeFailureInfo);
    }

    private void addVolumeFailureInfo(FsVolumeImpl vol) {
        this.addVolumeFailureInfo(new VolumeFailureInfo(new File(vol.getBasePath()).getAbsolutePath(), Time.now(), vol.getCapacity()));
    }

    private void removeVolumeFailureInfo(File vol) {
        this.volumeFailureInfos.remove(vol.getAbsolutePath());
    }

    void addBlockPool(final String bpid, final Configuration conf) throws IOException {
        long totalStartTime = Time.monotonicNow();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<2> blockPoolAddingThreads = new ArrayList<2>();
        for (final FsVolumeImpl v : this.volumes.get()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try (FsVolumeReference ref2 = v.obtainReference();){
                        FsDatasetImpl.LOG.info("Scanning block pool " + bpid + " on volume " + v + "...");
                        long startTime = Time.monotonicNow();
                        v.addBlockPool(bpid, conf);
                        long timeTaken = Time.monotonicNow() - startTime;
                        FsDatasetImpl.LOG.info("Time taken to scan block pool " + bpid + " on " + v + ": " + timeTaken + "ms");
                    }
                    catch (ClosedChannelException ref2) {
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info("Caught exception while scanning " + v + ". Will throw later.", ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            blockPoolAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : blockPoolAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = Time.monotonicNow() - totalStartTime;
        FsDatasetImpl.LOG.info("Total time to scan all replicas for block pool " + bpid + ": " + totalTimeTaken + "ms");
    }

    void removeBlockPool(String bpid) {
        for (FsVolumeImpl v : this.volumes.get()) {
            v.shutdownBlockPool(bpid);
        }
    }

    void shutdown() {
        for (FsVolumeImpl volume : this.volumes.get()) {
            if (volume == null) continue;
            volume.shutdown();
        }
    }
}

