/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.TabletServerBatchWriter;
import org.apache.accumulo.core.data.Mutation;

public class BatchWriterImpl
implements BatchWriter {
    private final String table;
    private final TabletServerBatchWriter bw;

    public BatchWriterImpl(ClientContext context, String table, BatchWriterConfig config) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table is null");
        if (config == null) {
            config = new BatchWriterConfig();
        }
        this.table = table;
        this.bw = new TabletServerBatchWriter(context, config);
    }

    @Override
    public void addMutation(Mutation m) throws MutationsRejectedException {
        Preconditions.checkArgument((m != null ? 1 : 0) != 0, (Object)"m is null");
        this.bw.addMutation(this.table, m);
    }

    @Override
    public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
        Preconditions.checkArgument((iterable != null ? 1 : 0) != 0, (Object)"iterable is null");
        this.bw.addMutation(this.table, iterable.iterator());
    }

    @Override
    public void close() throws MutationsRejectedException {
        this.bw.close();
    }

    @Override
    public void flush() throws MutationsRejectedException {
        this.bw.flush();
    }
}

