/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TMutation
implements TBase<TMutation, _Fields>,
Serializable,
Cloneable,
Comparable<TMutation> {
    private static final TStruct STRUCT_DESC = new TStruct("TMutation");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField DATA_FIELD_DESC = new TField("data", 11, 2);
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 3);
    private static final TField ENTRIES_FIELD_DESC = new TField("entries", 8, 4);
    private static final TField SOURCES_FIELD_DESC = new TField("sources", 15, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer row;
    public ByteBuffer data;
    public List<ByteBuffer> values;
    public int entries;
    public List<String> sources;
    private static final int __ENTRIES_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private _Fields[] optionals = new _Fields[]{_Fields.SOURCES};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TMutation() {
    }

    public TMutation(ByteBuffer row, ByteBuffer data, List<ByteBuffer> values, int entries) {
        this();
        this.row = row;
        this.data = data;
        this.values = values;
        this.entries = entries;
        this.setEntriesIsSet(true);
    }

    public TMutation(TMutation other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetRow()) {
            this.row = TBaseHelper.copyBinary((ByteBuffer)other.row);
        }
        if (other.isSetData()) {
            this.data = TBaseHelper.copyBinary((ByteBuffer)other.data);
        }
        if (other.isSetValues()) {
            ArrayList<ByteBuffer> __this__values = new ArrayList<ByteBuffer>(other.values);
            this.values = __this__values;
        }
        this.entries = other.entries;
        if (other.isSetSources()) {
            ArrayList<String> __this__sources = new ArrayList<String>(other.sources);
            this.sources = __this__sources;
        }
    }

    public TMutation deepCopy() {
        return new TMutation(this);
    }

    public void clear() {
        this.row = null;
        this.data = null;
        this.values = null;
        this.setEntriesIsSet(false);
        this.entries = 0;
        this.sources = null;
    }

    public byte[] getRow() {
        this.setRow(TBaseHelper.rightSize((ByteBuffer)this.row));
        return this.row == null ? null : this.row.array();
    }

    public ByteBuffer bufferForRow() {
        return this.row;
    }

    public TMutation setRow(byte[] row) {
        this.setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
        return this;
    }

    public TMutation setRow(ByteBuffer row) {
        this.row = row;
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public byte[] getData() {
        this.setData(TBaseHelper.rightSize((ByteBuffer)this.data));
        return this.data == null ? null : this.data.array();
    }

    public ByteBuffer bufferForData() {
        return this.data;
    }

    public TMutation setData(byte[] data) {
        this.setData(data == null ? (ByteBuffer)null : ByteBuffer.wrap(data));
        return this;
    }

    public TMutation setData(ByteBuffer data) {
        this.data = data;
        return this;
    }

    public void unsetData() {
        this.data = null;
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public void setDataIsSet(boolean value) {
        if (!value) {
            this.data = null;
        }
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    public Iterator<ByteBuffer> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(ByteBuffer elem) {
        if (this.values == null) {
            this.values = new ArrayList<ByteBuffer>();
        }
        this.values.add(elem);
    }

    public List<ByteBuffer> getValues() {
        return this.values;
    }

    public TMutation setValues(List<ByteBuffer> values) {
        this.values = values;
        return this;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean value) {
        if (!value) {
            this.values = null;
        }
    }

    public int getEntries() {
        return this.entries;
    }

    public TMutation setEntries(int entries) {
        this.entries = entries;
        this.setEntriesIsSet(true);
        return this;
    }

    public void unsetEntries() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetEntries() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setEntriesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getSourcesSize() {
        return this.sources == null ? 0 : this.sources.size();
    }

    public Iterator<String> getSourcesIterator() {
        return this.sources == null ? null : this.sources.iterator();
    }

    public void addToSources(String elem) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(elem);
    }

    public List<String> getSources() {
        return this.sources;
    }

    public TMutation setSources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public void unsetSources() {
        this.sources = null;
    }

    public boolean isSetSources() {
        return this.sources != null;
    }

    public void setSourcesIsSet(boolean value) {
        if (!value) {
            this.sources = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((ByteBuffer)value);
                break;
            }
            case DATA: {
                if (value == null) {
                    this.unsetData();
                    break;
                }
                this.setData((ByteBuffer)value);
                break;
            }
            case VALUES: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)value);
                break;
            }
            case ENTRIES: {
                if (value == null) {
                    this.unsetEntries();
                    break;
                }
                this.setEntries((Integer)value);
                break;
            }
            case SOURCES: {
                if (value == null) {
                    this.unsetSources();
                    break;
                }
                this.setSources((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROW: {
                return this.getRow();
            }
            case DATA: {
                return this.getData();
            }
            case VALUES: {
                return this.getValues();
            }
            case ENTRIES: {
                return this.getEntries();
            }
            case SOURCES: {
                return this.getSources();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ROW: {
                return this.isSetRow();
            }
            case DATA: {
                return this.isSetData();
            }
            case VALUES: {
                return this.isSetValues();
            }
            case ENTRIES: {
                return this.isSetEntries();
            }
            case SOURCES: {
                return this.isSetSources();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TMutation) {
            return this.equals((TMutation)that);
        }
        return false;
    }

    public boolean equals(TMutation that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!this.row.equals(that.row)) {
                return false;
            }
        }
        boolean this_present_data = this.isSetData();
        boolean that_present_data = that.isSetData();
        if (this_present_data || that_present_data) {
            if (!this_present_data || !that_present_data) {
                return false;
            }
            if (!this.data.equals(that.data)) {
                return false;
            }
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!this.values.equals(that.values)) {
                return false;
            }
        }
        boolean this_present_entries = true;
        boolean that_present_entries = true;
        if (this_present_entries || that_present_entries) {
            if (!this_present_entries || !that_present_entries) {
                return false;
            }
            if (this.entries != that.entries) {
                return false;
            }
        }
        boolean this_present_sources = this.isSetSources();
        boolean that_present_sources = that.isSetSources();
        if (this_present_sources || that_present_sources) {
            if (!this_present_sources || !that_present_sources) {
                return false;
            }
            if (!this.sources.equals(that.sources)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(TMutation other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRow()).compareTo(other.isSetRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.row, (Comparable)other.row)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetData()).compareTo(other.isSetData());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetData() && (lastComparison = TBaseHelper.compareTo((Comparable)this.data, (Comparable)other.data)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValues()).compareTo(other.isSetValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValues() && (lastComparison = TBaseHelper.compareTo(this.values, other.values)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEntries()).compareTo(other.isSetEntries());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEntries() && (lastComparison = TBaseHelper.compareTo((int)this.entries, (int)other.entries)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSources()).compareTo(other.isSetSources());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSources() && (lastComparison = TBaseHelper.compareTo(this.sources, other.sources)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TMutation(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.row, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("data:");
        if (this.data == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.data, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("values:");
        if (this.values == null) {
            sb.append("null");
        } else {
            sb.append(this.values);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("entries:");
        sb.append(this.entries);
        first = false;
        if (this.isSetSources()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sources:");
            if (this.sources == null) {
                sb.append("null");
            } else {
                sb.append(this.sources);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TMutationStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TMutationTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ROW, new FieldMetaData("row", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.DATA, new FieldMetaData("data", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.VALUES, new FieldMetaData("values", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.ENTRIES, new FieldMetaData("entries", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SOURCES, new FieldMetaData("sources", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TMutation.class, metaDataMap);
    }

    private static class TMutationTupleScheme
    extends TupleScheme<TMutation> {
        private TMutationTupleScheme() {
        }

        public void write(TProtocol prot, TMutation struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetRow()) {
                optionals.set(0);
            }
            if (struct.isSetData()) {
                optionals.set(1);
            }
            if (struct.isSetValues()) {
                optionals.set(2);
            }
            if (struct.isSetEntries()) {
                optionals.set(3);
            }
            if (struct.isSetSources()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetRow()) {
                oprot.writeBinary(struct.row);
            }
            if (struct.isSetData()) {
                oprot.writeBinary(struct.data);
            }
            if (struct.isSetValues()) {
                oprot.writeI32(struct.values.size());
                for (ByteBuffer _iter8 : struct.values) {
                    oprot.writeBinary(_iter8);
                }
            }
            if (struct.isSetEntries()) {
                oprot.writeI32(struct.entries);
            }
            if (struct.isSetSources()) {
                oprot.writeI32(struct.sources.size());
                for (String _iter9 : struct.sources) {
                    oprot.writeString(_iter9);
                }
            }
        }

        public void read(TProtocol prot, TMutation struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
            }
            if (incoming.get(1)) {
                struct.data = iprot.readBinary();
                struct.setDataIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list10 = new TList(11, iprot.readI32());
                struct.values = new ArrayList<ByteBuffer>(_list10.size);
                for (int _i11 = 0; _i11 < _list10.size; ++_i11) {
                    ByteBuffer _elem12 = iprot.readBinary();
                    struct.values.add(_elem12);
                }
                struct.setValuesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.entries = iprot.readI32();
                struct.setEntriesIsSet(true);
            }
            if (incoming.get(4)) {
                TList _list13 = new TList(11, iprot.readI32());
                struct.sources = new ArrayList<String>(_list13.size);
                for (int _i14 = 0; _i14 < _list13.size; ++_i14) {
                    String _elem15 = iprot.readString();
                    struct.sources.add(_elem15);
                }
                struct.setSourcesIsSet(true);
            }
        }
    }

    private static class TMutationTupleSchemeFactory
    implements SchemeFactory {
        private TMutationTupleSchemeFactory() {
        }

        public TMutationTupleScheme getScheme() {
            return new TMutationTupleScheme();
        }
    }

    private static class TMutationStandardScheme
    extends StandardScheme<TMutation> {
        private TMutationStandardScheme() {
        }

        public void read(TProtocol iprot, TMutation struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.row = iprot.readBinary();
                            struct.setRowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.data = iprot.readBinary();
                            struct.setDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.values = new ArrayList<ByteBuffer>(_list0.size);
                            for (int _i1 = 0; _i1 < _list0.size; ++_i1) {
                                ByteBuffer _elem2 = iprot.readBinary();
                                struct.values.add(_elem2);
                            }
                            iprot.readListEnd();
                            struct.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.entries = iprot.readI32();
                            struct.setEntriesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list3 = iprot.readListBegin();
                            struct.sources = new ArrayList<String>(_list3.size);
                            for (int _i4 = 0; _i4 < _list3.size; ++_i4) {
                                String _elem5 = iprot.readString();
                                struct.sources.add(_elem5);
                            }
                            iprot.readListEnd();
                            struct.setSourcesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TMutation struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.row != null) {
                oprot.writeFieldBegin(ROW_FIELD_DESC);
                oprot.writeBinary(struct.row);
                oprot.writeFieldEnd();
            }
            if (struct.data != null) {
                oprot.writeFieldBegin(DATA_FIELD_DESC);
                oprot.writeBinary(struct.data);
                oprot.writeFieldEnd();
            }
            if (struct.values != null) {
                oprot.writeFieldBegin(VALUES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.values.size()));
                for (ByteBuffer _iter6 : struct.values) {
                    oprot.writeBinary(_iter6);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(ENTRIES_FIELD_DESC);
            oprot.writeI32(struct.entries);
            oprot.writeFieldEnd();
            if (struct.sources != null && struct.isSetSources()) {
                oprot.writeFieldBegin(SOURCES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.sources.size()));
                for (String _iter7 : struct.sources) {
                    oprot.writeString(_iter7);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TMutationStandardSchemeFactory
    implements SchemeFactory {
        private TMutationStandardSchemeFactory() {
        }

        public TMutationStandardScheme getScheme() {
            return new TMutationStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROW(1, "row"),
        DATA(2, "data"),
        VALUES(3, "values"),
        ENTRIES(4, "entries"),
        SOURCES(5, "sources");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ROW;
                }
                case 2: {
                    return DATA;
                }
                case 3: {
                    return VALUES;
                }
                case 4: {
                    return ENTRIES;
                }
                case 5: {
                    return SOURCES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

