/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.map;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.file.map.MapFileUtil;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.MapFileIterator;
import org.apache.accumulo.core.iterators.system.SequenceFileIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class MapFileOperations
extends FileOperations {
    @Override
    public FileSKVIterator openReader(String file, boolean seekToBeginning, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        RangeIterator iter = new RangeIterator(new MapFileIterator(acuconf, fs, file, conf));
        if (seekToBeginning) {
            iter.seek(new Range(new Key(), null), new ArrayList<ByteSequence>(), false);
        }
        return iter;
    }

    @Override
    public FileSKVWriter openWriter(String file, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileSKVIterator openIndex(String file, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        return new SequenceFileIterator(MapFileUtil.openIndex(conf, fs, new Path(file)), false);
    }

    @Override
    public long getFileSize(String file, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        return fs.getFileStatus(new Path(file + "/" + "data")).getLen();
    }

    @Override
    public FileSKVIterator openReader(String file, Range range, Set<ByteSequence> columnFamilies, boolean inclusive, FileSystem fs, Configuration conf, AccumuloConfiguration tableConf) throws IOException {
        MapFileIterator mfIter = new MapFileIterator(tableConf, fs, file, conf);
        RangeIterator iter = new RangeIterator(mfIter);
        iter.seek(range, columnFamilies, inclusive);
        return iter;
    }

    @Override
    public FileSKVIterator openReader(String file, Range range, Set<ByteSequence> columnFamilies, boolean inclusive, FileSystem fs, Configuration conf, AccumuloConfiguration tableConf, BlockCache dataCache, BlockCache indexCache) throws IOException {
        return this.openReader(file, range, columnFamilies, inclusive, fs, conf, tableConf);
    }

    @Override
    public FileSKVIterator openReader(String file, boolean seekToBeginning, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf, BlockCache dataCache, BlockCache indexCache) throws IOException {
        return this.openReader(file, seekToBeginning, fs, conf, acuconf);
    }

    @Override
    public FileSKVIterator openIndex(String file, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf, BlockCache dCache, BlockCache iCache) throws IOException {
        return this.openIndex(file, fs, conf, acuconf);
    }

    public static class RangeIterator
    implements FileSKVIterator {
        SortedKeyValueIterator<Key, Value> reader;
        private Range range;
        private boolean hasTop;

        public RangeIterator(SortedKeyValueIterator<Key, Value> reader) {
            this.reader = reader;
        }

        @Override
        public void close() throws IOException {
            ((FileSKVIterator)this.reader).close();
        }

        @Override
        public Key getFirstKey() throws IOException {
            return ((FileSKVIterator)this.reader).getFirstKey();
        }

        @Override
        public Key getLastKey() throws IOException {
            return ((FileSKVIterator)this.reader).getLastKey();
        }

        @Override
        public DataInputStream getMetaStore(String name) throws IOException {
            return ((FileSKVIterator)this.reader).getMetaStore(name);
        }

        @Override
        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            return new RangeIterator(this.reader.deepCopy(env));
        }

        @Override
        public Key getTopKey() {
            if (!this.hasTop) {
                throw new IllegalStateException();
            }
            return this.reader.getTopKey();
        }

        @Override
        public Value getTopValue() {
            if (!this.hasTop) {
                throw new IllegalStateException();
            }
            return this.reader.getTopValue();
        }

        @Override
        public boolean hasTop() {
            return this.hasTop;
        }

        @Override
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void next() throws IOException {
            if (!this.hasTop) {
                throw new IllegalStateException();
            }
            this.reader.next();
            this.hasTop = this.reader.hasTop() && !this.range.afterEndKey(this.reader.getTopKey());
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            this.reader.seek(range, columnFamilies, inclusive);
            this.range = range;
            boolean bl = this.hasTop = this.reader.hasTop() && !range.afterEndKey(this.reader.getTopKey());
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }

        @Override
        public void closeDeepCopies() throws IOException {
            ((FileSKVIterator)this.reader).closeDeepCopies();
        }

        @Override
        public void setInterruptFlag(AtomicBoolean flag) {
            ((FileSKVIterator)this.reader).setInterruptFlag(flag);
        }
    }
}

