/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.atop;

import com.facebook.presto.atop.AtopConnectorConfig;
import com.facebook.presto.atop.AtopSplit;
import com.facebook.presto.atop.AtopTableHandle;
import com.facebook.presto.atop.AtopTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;

public class AtopSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final ZoneId timeZone;
    private final int maxHistoryDays;

    @Inject
    public AtopSplitManager(NodeManager nodeManager, AtopConnectorConfig config) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(config, "config is null");
        this.timeZone = config.getTimeZoneId();
        this.maxHistoryDays = config.getMaxHistoryDays();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layoutHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        AtopTableLayoutHandle handle = (AtopTableLayoutHandle)layoutHandle;
        AtopTableHandle table = handle.getTableHandle();
        ArrayList<AtopSplit> splits = new ArrayList<AtopSplit>();
        ZonedDateTime end = ZonedDateTime.now(this.timeZone);
        for (Node node : this.nodeManager.getWorkerNodes()) {
            ZonedDateTime start = end.minusDays(this.maxHistoryDays - 1).withHour(0).withMinute(0).withSecond(0).withNano(0);
            while (start.isBefore(end)) {
                ZonedDateTime splitEnd = start.withHour(23).withMinute(59).withSecond(59).withNano(0);
                Domain splitDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)(1000L * start.toEpochSecond()), (boolean)true, (Object)(1000L * splitEnd.toEpochSecond()), (boolean)true), (Range[])new Range[0]), (boolean)false);
                if (handle.getStartTimeConstraint().overlaps(splitDomain) && handle.getEndTimeConstraint().overlaps(splitDomain)) {
                    splits.add(new AtopSplit(table.getTable(), node.getHostAndPort(), start.toEpochSecond(), start.getZone()));
                }
                start = start.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            }
        }
        return new FixedSplitSource(splits);
    }
}

