/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.atop;

import com.facebook.presto.atop.AtopMetadata;
import com.facebook.presto.atop.AtopPageSourceProvider;
import com.facebook.presto.atop.AtopSplitManager;
import com.facebook.presto.atop.AtopTransactionHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import java.util.Objects;
import javax.inject.Inject;

public class AtopConnector
implements Connector {
    private static final Logger log = Logger.get(AtopConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final AtopMetadata metadata;
    private final AtopSplitManager splitManager;
    private final AtopPageSourceProvider pageSourceProvider;
    private final ConnectorAccessControl accessControl;

    @Inject
    public AtopConnector(LifeCycleManager lifeCycleManager, AtopMetadata metadata, AtopSplitManager splitManager, AtopPageSourceProvider pageSourceProvider, ConnectorAccessControl accessControl) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return AtopTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

