/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.atop;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.atop.AtopConnector;
import com.facebook.presto.atop.AtopConnectorConfig;
import com.facebook.presto.atop.AtopFactory;
import com.facebook.presto.atop.AtopHandleResolver;
import com.facebook.presto.atop.AtopModule;
import com.facebook.presto.plugin.base.security.AllowAllAccessControlModule;
import com.facebook.presto.plugin.base.security.FileBasedAccessControlModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class AtopConnectorFactory
implements ConnectorFactory {
    private final Class<? extends AtopFactory> atopFactoryClass;
    private final ClassLoader classLoader;

    public AtopConnectorFactory(Class<? extends AtopFactory> atopFactoryClass, ClassLoader classLoader) {
        this.atopFactoryClass = Objects.requireNonNull(atopFactoryClass, "atopFactoryClass is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getName() {
        return "atop";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new AtopHandleResolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new AtopModule(this.atopFactoryClass, context.getTypeManager(), context.getNodeManager(), context.getNodeManager().getEnvironment(), catalogName), ConditionalModule.installModuleIf(AtopConnectorConfig.class, config -> config.getSecurity().equalsIgnoreCase("none"), (Module)new AllowAllAccessControlModule()), ConditionalModule.installModuleIf(AtopConnectorConfig.class, config -> config.getSecurity().equalsIgnoreCase("file"), binder -> {
                binder.install((Module)new FileBasedAccessControlModule());
                binder.install((Module)new JsonModule());
            })});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            Connector connector = (Connector)injector.getInstance(AtopConnector.class);
            return connector;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

