/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.atop;

import com.facebook.presto.atop.AtopColumnHandle;
import com.facebook.presto.atop.AtopTable;
import com.facebook.presto.atop.AtopTableHandle;
import com.facebook.presto.atop.AtopTableLayoutHandle;
import com.facebook.presto.atop.Environment;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnNotFoundException;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public class AtopMetadata
implements ConnectorMetadata {
    private static final AtopColumnHandle START_TIME_HANDLE = new AtopColumnHandle(AtopTable.AtopColumn.START_TIME.getName());
    private static final AtopColumnHandle END_TIME_HANDLE = new AtopColumnHandle(AtopTable.AtopColumn.END_TIME.getName());
    private final TypeManager typeManager;
    private final String environment;

    @Inject
    public AtopMetadata(TypeManager typeManager, Environment environment) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.environment = Objects.requireNonNull(environment, "environment is null").toString();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)"default", (Object)this.environment);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        String schemaName = tableName.getSchemaName();
        if (!this.listSchemaNames(session).contains(schemaName)) {
            return null;
        }
        try {
            AtopTable table = AtopTable.valueOf(tableName.getTableName().toUpperCase());
            return new AtopTableHandle(schemaName, table);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        AtopTableHandle tableHandle = (AtopTableHandle)table;
        Optional domains = constraint.getSummary().getDomains();
        Domain endTimeDomain = Domain.all((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        Domain startTimeDomain = Domain.all((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        if (domains.isPresent()) {
            if (((Map)domains.get()).containsKey(START_TIME_HANDLE)) {
                startTimeDomain = (Domain)((Map)domains.get()).get(START_TIME_HANDLE);
            }
            if (((Map)domains.get()).containsKey(END_TIME_HANDLE)) {
                endTimeDomain = (Domain)((Map)domains.get()).get(END_TIME_HANDLE);
            }
        }
        AtopTableLayoutHandle layoutHandle = new AtopTableLayoutHandle(tableHandle, startTimeDomain, endTimeDomain);
        ConnectorTableLayout tableLayout = this.getTableLayout(session, layoutHandle);
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(tableLayout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle tableLayoutHandle) {
        return new ConnectorTableLayout(tableLayoutHandle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        AtopTableHandle atopTableHandle = (AtopTableHandle)tableHandle;
        ImmutableList.Builder columns = ImmutableList.builder();
        for (AtopTable.AtopColumn column : atopTableHandle.getTable().getColumns()) {
            columns.add((Object)new ColumnMetadata(column.getName(), this.typeManager.getType(column.getType())));
        }
        SchemaTableName schemaTableName = new SchemaTableName(atopTableHandle.getSchema(), atopTableHandle.getTable().getName());
        return new ConnectorTableMetadata(schemaTableName, (List)columns.build());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return Stream.of(AtopTable.values()).map(table -> new SchemaTableName(this.environment, table.getName())).collect(Collectors.toList());
        }
        if (!this.listSchemaNames(session).contains(schemaNameOrNull)) {
            return ImmutableList.of();
        }
        return Stream.of(AtopTable.values()).map(table -> new SchemaTableName(schemaNameOrNull, table.getName())).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        AtopTableHandle atopTableHandle = (AtopTableHandle)tableHandle;
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (AtopTable.AtopColumn column : atopTableHandle.getTable().getColumns()) {
            columnHandles.put((Object)column.getName(), (Object)new AtopColumnHandle(column.getName()));
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchemaName())) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, this.getTableHandle(session, tableName));
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName = ((AtopColumnHandle)columnHandle).getName();
        for (ColumnMetadata column : this.getTableMetadata(session, tableHandle).getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        AtopTableHandle atopTableHandle = (AtopTableHandle)tableHandle;
        SchemaTableName tableName = new SchemaTableName(atopTableHandle.getSchema(), atopTableHandle.getTable().getName());
        throw new ColumnNotFoundException(tableName, columnName);
    }
}

