/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class DriverConnectionFactory
implements ConnectionFactory {
    private final Driver driver;
    private final String connectionUrl;
    private final Properties connectionProperties;
    private final Optional<String> userCredentialName;
    private final Optional<String> passwordCredentialName;

    public DriverConnectionFactory(Driver driver, BaseJdbcConfig config) {
        this(driver, config.getConnectionUrl(), Optional.ofNullable(config.getUserCredentialName()), Optional.ofNullable(config.getPasswordCredentialName()), DriverConnectionFactory.basicConnectionProperties(config));
    }

    public static Properties basicConnectionProperties(BaseJdbcConfig config) {
        Properties connectionProperties = new Properties();
        if (config.getConnectionUser() != null) {
            connectionProperties.setProperty("user", config.getConnectionUser());
        }
        if (config.getConnectionPassword() != null) {
            connectionProperties.setProperty("password", config.getConnectionPassword());
        }
        return connectionProperties;
    }

    public DriverConnectionFactory(Driver driver, String connectionUrl, Optional<String> userCredentialName, Optional<String> passwordCredentialName, Properties connectionProperties) {
        this.driver = Objects.requireNonNull(driver, "driver is null");
        this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)Objects.requireNonNull(connectionProperties, "connectionProperties is null"));
        this.userCredentialName = Objects.requireNonNull(userCredentialName, "userCredentialName is null");
        this.passwordCredentialName = Objects.requireNonNull(passwordCredentialName, "passwordCredentialName is null");
    }

    @Override
    public Connection openConnection(JdbcIdentity identity) throws SQLException {
        Properties updatedConnectionProperties;
        if (this.userCredentialName.isPresent() || this.passwordCredentialName.isPresent()) {
            updatedConnectionProperties = new Properties();
            updatedConnectionProperties.putAll((Map<?, ?>)this.connectionProperties);
            this.userCredentialName.ifPresent(credentialName -> DriverConnectionFactory.setConnectionProperty(updatedConnectionProperties, identity.getExtraCredentials(), credentialName, "user"));
            this.passwordCredentialName.ifPresent(credentialName -> DriverConnectionFactory.setConnectionProperty(updatedConnectionProperties, identity.getExtraCredentials(), credentialName, "password"));
        } else {
            updatedConnectionProperties = this.connectionProperties;
        }
        Connection connection = this.driver.connect(this.connectionUrl, updatedConnectionProperties);
        Preconditions.checkState((connection != null ? 1 : 0) != 0, (Object)"Driver returned null connection");
        return connection;
    }

    private static void setConnectionProperty(Properties connectionProperties, Map<String, String> extraCredentials, String credentialName, String propertyName) {
        String value = extraCredentials.get(credentialName);
        if (value != null) {
            connectionProperties.setProperty(propertyName, value);
        }
    }
}

