/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableLayoutHandle;
import com.facebook.presto.plugin.jdbc.JdbcTypeHandle;
import com.facebook.presto.plugin.jdbc.ReadMapping;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.statistics.TableStatistics;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public interface JdbcClient {
    default public boolean schemaExists(ConnectorSession session, JdbcIdentity identity, String schema) {
        return this.getSchemaNames(session, identity).contains(schema);
    }

    public String getIdentifierQuote();

    public Set<String> getSchemaNames(ConnectorSession var1, JdbcIdentity var2);

    public List<SchemaTableName> getTableNames(ConnectorSession var1, JdbcIdentity var2, Optional<String> var3);

    @Nullable
    public JdbcTableHandle getTableHandle(ConnectorSession var1, JdbcIdentity var2, SchemaTableName var3);

    public List<JdbcColumnHandle> getColumns(ConnectorSession var1, JdbcTableHandle var2);

    public Optional<ReadMapping> toPrestoType(ConnectorSession var1, JdbcTypeHandle var2);

    public ConnectorSplitSource getSplits(ConnectorSession var1, JdbcIdentity var2, JdbcTableLayoutHandle var3);

    public Connection getConnection(ConnectorSession var1, JdbcIdentity var2, JdbcSplit var3) throws SQLException;

    default public void abortReadConnection(Connection connection) throws SQLException {
    }

    public PreparedStatement buildSql(ConnectorSession var1, Connection var2, JdbcSplit var3, List<JdbcColumnHandle> var4) throws SQLException;

    public void addColumn(ConnectorSession var1, JdbcIdentity var2, JdbcTableHandle var3, ColumnMetadata var4);

    public void dropColumn(ConnectorSession var1, JdbcIdentity var2, JdbcTableHandle var3, JdbcColumnHandle var4);

    public void renameColumn(ConnectorSession var1, JdbcIdentity var2, JdbcTableHandle var3, JdbcColumnHandle var4, String var5);

    public void renameTable(ConnectorSession var1, JdbcIdentity var2, JdbcTableHandle var3, SchemaTableName var4);

    public void createTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void commitCreateTable(ConnectorSession var1, JdbcIdentity var2, JdbcOutputTableHandle var3);

    public JdbcOutputTableHandle beginInsertTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void finishInsertTable(ConnectorSession var1, JdbcIdentity var2, JdbcOutputTableHandle var3);

    public void dropTable(ConnectorSession var1, JdbcIdentity var2, JdbcTableHandle var3);

    public void truncateTable(ConnectorSession var1, JdbcIdentity var2, JdbcTableHandle var3);

    public void rollbackCreateTable(ConnectorSession var1, JdbcIdentity var2, JdbcOutputTableHandle var3);

    public String buildInsertSql(ConnectorSession var1, JdbcOutputTableHandle var2);

    public Connection getConnection(ConnectorSession var1, JdbcIdentity var2, JdbcOutputTableHandle var3) throws SQLException;

    public PreparedStatement getPreparedStatement(ConnectorSession var1, Connection var2, String var3) throws SQLException;

    public TableStatistics getTableStatistics(ConnectorSession var1, JdbcTableHandle var2, List<JdbcColumnHandle> var3, TupleDomain<ColumnHandle> var4);
}

