/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.JoinBridgeDataManager;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.LookupSourceProvider;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.NullOutputOperator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Future;

public class HashJoinBenchmark
extends AbstractOperatorBenchmark {
    private static final LookupJoinOperators LOOKUP_JOIN_OPERATORS = new LookupJoinOperators();
    private JoinBridgeDataManager<LookupSourceFactory> lookupSourceFactoryManager;

    public HashJoinBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_join", 4, 50);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        if (this.lookupSourceFactoryManager == null) {
            List<Type> ordersTypes = this.getColumnTypes("orders", "orderkey", "totalprice");
            OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
            JoinBridgeDataManager lookupSourceFactoryManager = JoinBridgeDataManager.lookupAllAtOnce((LookupSourceFactory)new PartitionedLookupSourceFactory(ordersTypes, (List)ImmutableList.of((Object)0, (Object)1).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), (List)Ints.asList((int[])new int[]{0}).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), 1, (Map)Objects.requireNonNull(ImmutableMap.of(), "layout is null"), false));
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(1, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)0, (Object)1), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory());
            DriverContext driverContext = taskContext.addPipelineContext(0, false, false).addDriverContext();
            Driver driver = new DriverFactory(0, false, false, (List)ImmutableList.of((Object)ordersTableScan, (Object)hashBuilder), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION).createDriver(driverContext);
            ListenableFuture lookupSourceProvider = ((LookupSourceFactory)lookupSourceFactoryManager.forLifespan(Lifespan.taskWide())).createLookupSourceProvider();
            while (!lookupSourceProvider.isDone()) {
                driver.process();
            }
            ((LookupSourceProvider)MoreFutures.getFutureValue((Future)lookupSourceProvider)).close();
            this.lookupSourceFactoryManager = lookupSourceFactoryManager;
        }
        List<Type> lineItemTypes = this.getColumnTypes("lineitem", "orderkey", "quantity");
        OperatorFactory lineItemTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "orderkey", "quantity");
        OperatorFactory joinOperator = LOOKUP_JOIN_OPERATORS.innerJoin(1, new PlanNodeId("test"), this.lookupSourceFactoryManager, lineItemTypes, Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory());
        NullOutputOperator.NullOutputOperatorFactory output = new NullOutputOperator.NullOutputOperatorFactory(2, new PlanNodeId("test"));
        DriverFactory driverFactory = new DriverFactory(1, true, true, (List)ImmutableList.of((Object)lineItemTableScan, (Object)joinOperator, (Object)output), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        DriverContext driverContext = taskContext.addPipelineContext(1, true, true).addDriverContext();
        Driver driver = driverFactory.createDriver(driverContext);
        return ImmutableList.of((Object)driver);
    }

    public static void main(String[] args) {
        new HashJoinBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

