/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.plugin.blackhole.BlackHoleMetadata;
import com.facebook.presto.plugin.blackhole.BlackHoleNodePartitioningProvider;
import com.facebook.presto.plugin.blackhole.BlackHolePageSinkProvider;
import com.facebook.presto.plugin.blackhole.BlackHolePageSourceProvider;
import com.facebook.presto.plugin.blackhole.BlackHoleSplitManager;
import com.facebook.presto.plugin.blackhole.BlackHoleTransactionHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class BlackHoleConnector
implements Connector {
    public static final String SPLIT_COUNT_PROPERTY = "split_count";
    public static final String PAGES_PER_SPLIT_PROPERTY = "pages_per_split";
    public static final String ROWS_PER_PAGE_PROPERTY = "rows_per_page";
    public static final String FIELD_LENGTH_PROPERTY = "field_length";
    public static final String DISTRIBUTED_ON = "distributed_on";
    public static final String PAGE_PROCESSING_DELAY = "page_processing_delay";
    private final BlackHoleMetadata metadata;
    private final BlackHoleSplitManager splitManager;
    private final BlackHolePageSourceProvider pageSourceProvider;
    private final BlackHolePageSinkProvider pageSinkProvider;
    private final BlackHoleNodePartitioningProvider partitioningProvider;
    private final TypeManager typeManager;
    private final ExecutorService executorService;

    public BlackHoleConnector(BlackHoleMetadata metadata, BlackHoleSplitManager splitManager, BlackHolePageSourceProvider pageSourceProvider, BlackHolePageSinkProvider pageSinkProvider, BlackHoleNodePartitioningProvider partitioningProvider, TypeManager typeManager, ExecutorService executorService) {
        this.metadata = metadata;
        this.splitManager = splitManager;
        this.pageSourceProvider = pageSourceProvider;
        this.pageSinkProvider = pageSinkProvider;
        this.partitioningProvider = partitioningProvider;
        this.typeManager = typeManager;
        this.executorService = executorService;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return BlackHoleTransactionHandle.INSTANCE;
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return ImmutableList.of((Object)PropertyMetadata.integerSessionProperty((String)SPLIT_COUNT_PROPERTY, (String)"Number of splits generated by this table", (Integer)0, (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)PAGES_PER_SPLIT_PROPERTY, (String)"Number of pages per each split generated by this table", (Integer)0, (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)ROWS_PER_PAGE_PROPERTY, (String)"Number of rows per each page generated by this table", (Integer)0, (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)FIELD_LENGTH_PROPERTY, (String)"Overwrite default length (16) of variable length columns, such as VARCHAR or VARBINARY", (Integer)16, (boolean)false), (Object)new PropertyMetadata(DISTRIBUTED_ON, "Distribution columns", this.typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)VarcharType.createUnboundedVarcharType().getTypeSignature()))), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((List)value).stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), List.class::cast), (Object)new PropertyMetadata(PAGE_PROCESSING_DELAY, "Sleep duration before processing each page", (Type)VarcharType.VARCHAR, Duration.class, (Object)new Duration(0.0, TimeUnit.SECONDS), false, value -> Duration.valueOf((String)((String)value)), Duration::toString));
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.partitioningProvider;
    }

    public void shutdown() {
        this.executorService.shutdownNow();
    }
}

