/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;

public final class BlackHoleSplit
implements ConnectorSplit {
    private final int pagesCount;
    private final int rowsPerPage;
    private final int fieldsLength;
    private final Duration pageProcessingDelay;

    @JsonCreator
    public BlackHoleSplit(@JsonProperty(value="pagesCount") int pagesCount, @JsonProperty(value="rowsPerPage") int rowsPerPage, @JsonProperty(value="fieldsLength") int fieldsLength, @JsonProperty(value="pageProcessingDelay") Duration pageProcessingDelay) {
        this.rowsPerPage = rowsPerPage;
        this.pagesCount = pagesCount;
        this.fieldsLength = fieldsLength;
        this.pageProcessingDelay = Objects.requireNonNull(pageProcessingDelay, "pageProcessingDelay is null");
    }

    @JsonProperty
    public int getPagesCount() {
        return this.pagesCount;
    }

    @JsonProperty
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @JsonProperty
    public int getFieldsLength() {
        return this.fieldsLength;
    }

    @JsonProperty
    public Duration getPageProcessingDelay() {
        return this.pageProcessingDelay;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.getPagesCount(), this.getRowsPerPage());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlackHoleSplit other = (BlackHoleSplit)obj;
        return Objects.equals(this.getPagesCount(), other.getPagesCount()) && Objects.equals(this.getRowsPerPage(), other.getRowsPerPage());
    }
}

