/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class BlackHoleColumnHandle
implements ColumnHandle {
    private final String name;
    private final Type columnType;

    public BlackHoleColumnHandle(ColumnMetadata columnMetadata) {
        this(columnMetadata.getName(), columnMetadata.getType());
    }

    @JsonCreator
    public BlackHoleColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="columnType") Type columnType) {
        this.name = name;
        this.columnType = columnType;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    public ColumnMetadata toColumnMetadata() {
        return new ColumnMetadata(this.name, this.columnType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.columnType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlackHoleColumnHandle other = (BlackHoleColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.columnType, other.columnType);
    }
}

