/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.plugin.blackhole.BlackHoleColumnHandle;
import com.facebook.presto.plugin.blackhole.BlackHolePageSource;
import com.facebook.presto.plugin.blackhole.BlackHoleSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class BlackHolePageSourceProvider
implements ConnectorPageSourceProvider {
    private final ListeningScheduledExecutorService executorService;

    public BlackHolePageSourceProvider(ListeningScheduledExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, SplitContext splitContext) {
        BlackHoleSplit blackHoleSplit = (BlackHoleSplit)split;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            builder.add((Object)((BlackHoleColumnHandle)column).getColumnType());
        }
        ImmutableList types = builder.build();
        Page page = this.generateZeroPage((List<Type>)types, blackHoleSplit.getRowsPerPage(), blackHoleSplit.getFieldsLength());
        return new BlackHolePageSource(page, blackHoleSplit.getPagesCount(), this.executorService, blackHoleSplit.getPageProcessingDelay());
    }

    private Page generateZeroPage(List<Type> types, int rowsCount, int fieldLength) {
        byte[] constantBytes = new byte[fieldLength];
        Arrays.fill(constantBytes, (byte)42);
        Slice constantSlice = Slices.wrappedBuffer((byte[])constantBytes);
        Block[] blocks = new Block[types.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.createZeroBlock(types.get(i), rowsCount, constantSlice);
        }
        return new Page(rowsCount, blocks);
    }

    private Block createZeroBlock(Type type, int rowsCount, Slice constantSlice) {
        Preconditions.checkArgument((boolean)this.isSupportedType(type), (String)"Unsupported type [%s]", (Object)type);
        Slice slice = Varchars.isVarcharType((Type)type) ? constantSlice.slice(0, Math.min(((VarcharType)type).getLength(), constantSlice.length())) : (Decimals.isLongDecimal((Type)type) ? Decimals.encodeScaledValue((BigDecimal)BigDecimal.ZERO) : constantSlice);
        BlockBuilder builder = type instanceof FixedWidthType ? type.createBlockBuilder(null, rowsCount) : type.createBlockBuilder(null, rowsCount, slice.length());
        for (int i = 0; i < rowsCount; ++i) {
            Class javaType = type.getJavaType();
            if (javaType == Boolean.TYPE) {
                type.writeBoolean(builder, false);
                continue;
            }
            if (javaType == Long.TYPE) {
                type.writeLong(builder, 0L);
                continue;
            }
            if (javaType == Double.TYPE) {
                type.writeDouble(builder, 0.0);
                continue;
            }
            if (javaType == Slice.class) {
                Objects.requireNonNull(slice, "slice is null");
                type.writeSlice(builder, slice, 0, slice.length());
                continue;
            }
            throw new UnsupportedOperationException("Unknown javaType: " + javaType.getName());
        }
        return builder.build();
    }

    private boolean isSupportedType(Type type) {
        return ImmutableSet.of((Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object[])new Type[]{BooleanType.BOOLEAN, DateType.DATE, TimestampType.TIMESTAMP, VarbinaryType.VARBINARY}).contains((Object)type) || Varchars.isVarcharType((Type)type) || type instanceof DecimalType;
    }
}

