/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.units.Duration;
import java.util.Objects;

public final class BlackHoleTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final int splitCount;
    private final int pagesPerSplit;
    private final int rowsPerPage;
    private final int fieldsLength;
    private final Duration pageProcessingDelay;

    @JsonCreator
    public BlackHoleTableLayoutHandle(@JsonProperty(value="splitCount") int splitCount, @JsonProperty(value="pagesPerSplit") int pagesPerSplit, @JsonProperty(value="rowsPerPage") int rowsPerPage, @JsonProperty(value="fieldsLength") int fieldsLength, @JsonProperty(value="pageProcessingDelay") Duration pageProcessingDelay) {
        this.splitCount = splitCount;
        this.pagesPerSplit = pagesPerSplit;
        this.rowsPerPage = rowsPerPage;
        this.fieldsLength = fieldsLength;
        this.pageProcessingDelay = pageProcessingDelay;
    }

    @JsonProperty
    public int getSplitCount() {
        return this.splitCount;
    }

    @JsonProperty
    public int getPagesPerSplit() {
        return this.pagesPerSplit;
    }

    @JsonProperty
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @JsonProperty
    public int getFieldsLength() {
        return this.fieldsLength;
    }

    @JsonProperty
    public Duration getPageProcessingDelay() {
        return this.pageProcessingDelay;
    }

    public int hashCode() {
        return Objects.hash(this.getSplitCount(), this.getPagesPerSplit(), this.getRowsPerPage());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlackHoleTableLayoutHandle other = (BlackHoleTableLayoutHandle)obj;
        return Objects.equals(this.getSplitCount(), other.getSplitCount()) && Objects.equals(this.getPagesPerSplit(), other.getPagesPerSplit()) && Objects.equals(this.getRowsPerPage(), other.getRowsPerPage());
    }
}

