/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.common.Page;
import com.facebook.presto.spi.ConnectorPageSink;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

class BlackHolePageSink
implements ConnectorPageSink {
    private static final CompletableFuture<Collection<Slice>> NON_BLOCKED = CompletableFuture.completedFuture(ImmutableList.of());
    private final ListeningScheduledExecutorService executorService;
    private final long pageProcessingDelayMillis;
    private CompletableFuture<Collection<Slice>> appendFuture = NON_BLOCKED;

    public BlackHolePageSink(ListeningScheduledExecutorService executorService, Duration pageProcessingDelay) {
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        this.pageProcessingDelayMillis = Objects.requireNonNull(pageProcessingDelay, "pageProcessingDelay is null").toMillis();
    }

    public CompletableFuture<?> appendPage(Page page) {
        this.appendFuture = this.scheduleAppend();
        return this.appendFuture;
    }

    private CompletableFuture<Collection<Slice>> scheduleAppend() {
        if (this.pageProcessingDelayMillis > 0L) {
            return MoreFutures.toCompletableFuture((ListenableFuture)this.executorService.schedule(() -> ImmutableList.of(), this.pageProcessingDelayMillis, TimeUnit.MILLISECONDS));
        }
        return NON_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return this.appendFuture;
    }

    public void abort() {
    }
}

