/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheType;
import com.facebook.presto.hive.CacheQuotaScope;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.Map;
import org.testng.annotations.Test;

public class TestCacheConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((CacheConfig)ConfigAssertions.recordDefaults(CacheConfig.class)).setCachingEnabled(false).setCacheType(null).setBaseDirectory(null).setValidationEnabled(false).setCacheQuotaScope(CacheQuotaScope.GLOBAL).setDefaultCacheQuota(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws Exception {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"cache.enabled", (Object)"true").put((Object)"cache.type", (Object)"FILE_MERGE").put((Object)"cache.base-directory", (Object)"tcp://abc").put((Object)"cache.validation-enabled", (Object)"true").put((Object)"cache.cache-quota-scope", (Object)"TABLE").put((Object)"cache.default-cache-quota", (Object)"1GB").build();
        CacheConfig expected = new CacheConfig().setCachingEnabled(true).setCacheType(CacheType.FILE_MERGE).setBaseDirectory(new URI("tcp://abc")).setValidationEnabled(true).setCacheQuotaScope(CacheQuotaScope.TABLE).setDefaultCacheQuota(DataSize.succinctDataSize((double)1.0, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

