/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;

public class TestingCacheUtils {
    private TestingCacheUtils() {
    }

    public static void validateBuffer(byte[] data, long position, byte[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((byte)buffer[i + offset], (byte)data[i + (int)position], (String)String.format("corrupted buffer at position %s offset %s", position, i));
        }
    }

    public static void stressTest(byte[] data, TestingReadOperation testingReadOperation) throws ExecutionException, InterruptedException {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(5);
        ArrayList futures = new ArrayList();
        AtomicReference exception = new AtomicReference();
        for (int i = 0; i < 5; ++i) {
            byte[] byArray = new byte[data.length];
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 200; ++j) {
                    int position = random.nextInt(data.length - 1);
                    int length = random.nextInt(Integer.max((data.length - position) / 3, 1));
                    int offset = random.nextInt(data.length - length);
                    try {
                        testingReadOperation.invoke(position, buffer, offset, length);
                    }
                    catch (IOException e) {
                        exception.compareAndSet(null, e.getMessage());
                        return;
                    }
                    TestingCacheUtils.validateBuffer(data, position, buffer, offset, length);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        if (exception.get() != null) {
            Assert.fail((String)((String)exception.get()));
        }
    }

    public static interface TestingReadOperation {
        public void invoke(long var1, byte[] var3, int var4, int var5) throws IOException;
    }
}

