/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

class ByteArraySeekableStream
extends InputStream
implements Seekable,
PositionedReadable {
    private final ByteArrayInputStream inputStream;
    private final int length;

    public ByteArraySeekableStream(byte[] bytes) {
        this.inputStream = new ByteArrayInputStream(Objects.requireNonNull(bytes, "Input byte array is null"));
        this.length = bytes.length;
    }

    @Override
    public int read() {
        return this.inputStream.read();
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = this.read(position + (long)totalBytesRead, buffer, offset + totalBytesRead, length - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new EOFException();
        }
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void seek(long position) throws IOException {
        try {
            this.inputStream.reset();
            this.inputStream.skip(position);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public long getPos() {
        return this.length - this.inputStream.available();
    }

    public boolean seekToNewSource(long targetPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        super.close();
    }
}

