/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.cache.alluxio.AlluxioCacheConfig;
import com.facebook.presto.cache.alluxio.EvictionPolicy;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestAlluxioCacheConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((AlluxioCacheConfig)ConfigAssertions.recordDefaults(AlluxioCacheConfig.class)).setAsyncWriteEnabled(false).setConfigValidationEnabled(false).setEvictionRetries(10).setEvictionPolicy(EvictionPolicy.LRU).setJmxClass("alluxio.metrics.sink.JmxSink").setMaxCacheSize(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setMetricsCollectionEnabled(true).setMetricsDomain("com.facebook.alluxio").setTimeoutDuration(new Duration(60.0, TimeUnit.SECONDS)).setTimeoutEnabled(true).setTimeoutThreads(64).setCacheQuotaEnabled(false).setShadowCacheEnabled(false).setShadowCacheWindow(new Duration(7.0, TimeUnit.DAYS)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"cache.alluxio.async-write-enabled", (Object)"true").put((Object)"cache.alluxio.config-validation-enabled", (Object)"true").put((Object)"cache.alluxio.eviction-retries", (Object)"5").put((Object)"cache.alluxio.eviction-policy", (Object)"LFU").put((Object)"cache.alluxio.jmx-class", (Object)"test.TestJmxSink").put((Object)"cache.alluxio.max-cache-size", (Object)"42MB").put((Object)"cache.alluxio.metrics-domain", (Object)"test.alluxio").put((Object)"cache.alluxio.metrics-enabled", (Object)"false").put((Object)"cache.alluxio.timeout-duration", (Object)"120s").put((Object)"cache.alluxio.timeout-enabled", (Object)"false").put((Object)"cache.alluxio.timeout-threads", (Object)"512").put((Object)"cache.alluxio.quota-enabled", (Object)"true").put((Object)"cache.alluxio.shadow-cache-enabled", (Object)"true").put((Object)"cache.alluxio.shadow-cache-window", (Object)"1d").build();
        AlluxioCacheConfig expected = new AlluxioCacheConfig().setAsyncWriteEnabled(true).setEvictionRetries(5).setEvictionPolicy(EvictionPolicy.LFU).setMaxCacheSize(new DataSize(42.0, DataSize.Unit.MEGABYTE)).setMetricsCollectionEnabled(false).setMetricsDomain("test.alluxio").setJmxClass("test.TestJmxSink").setConfigValidationEnabled(true).setTimeoutDuration(new Duration(120.0, TimeUnit.SECONDS)).setTimeoutEnabled(false).setTimeoutThreads(512).setCacheQuotaEnabled(true).setShadowCacheEnabled(true).setShadowCacheWindow(new Duration(1.0, TimeUnit.DAYS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

