/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.client.file.cache.CacheManager;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.org.apache.commons.lang3.NotImplementedException;
import alluxio.util.io.FileUtils;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheType;
import com.facebook.presto.cache.TestingCacheUtils;
import com.facebook.presto.cache.alluxio.AlluxioCacheConfig;
import com.facebook.presto.cache.alluxio.AlluxioCachingConfigurationProvider;
import com.facebook.presto.cache.alluxio.AlluxioCachingFileSystem;
import com.facebook.presto.cache.alluxio.ByteArraySeekableStream;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.CacheQuotaScope;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestAlluxioCachingFileSystem {
    private static final int DATA_LENGTH = (int)new DataSize(20.0, DataSize.Unit.KILOBYTE).toBytes();
    private static final int PAGE_SIZE = (int)new DataSize(1.0, DataSize.Unit.KILOBYTE).toBytes();
    private final byte[] data = new byte[DATA_LENGTH];
    private URI cacheDirectory;
    private String testFilePath;
    private Map<String, Long> baseline = new HashMap<String, Long>();

    @BeforeClass
    public void setup() throws IOException {
        new Random().nextBytes(this.data);
        this.cacheDirectory = Files.createTempDirectory("alluxio_cache", new FileAttribute[0]).toUri();
    }

    @AfterClass
    public void close() throws IOException {
        Preconditions.checkState((this.cacheDirectory != null ? 1 : 0) != 0);
        FileUtils.deletePathRecursively((String)this.cacheDirectory.getPath());
    }

    @BeforeMethod
    public void setupMethod() {
        this.testFilePath = String.format("/test/file_%d", new Random().nextLong());
        this.resetBaseline();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.resetCacheManager();
    }

    @Test(timeOut=30000L)
    public void testBasicWithValidationDisabled() throws Exception {
        this.testBasic(false);
    }

    private void testBasic(boolean validationEnabled) throws Exception {
        CacheConfig cacheConfig = new CacheConfig().setCacheType(CacheType.ALLUXIO).setCachingEnabled(true).setBaseDirectory(this.cacheDirectory).setValidationEnabled(validationEnabled);
        AlluxioCacheConfig alluxioCacheConfig = new AlluxioCacheConfig();
        Configuration configuration = this.getHdfsConfiguration(cacheConfig, alluxioCacheConfig);
        AlluxioCachingFileSystem fileSystem = this.cachingFileSystem(configuration);
        Path p = new Path("/tmp");
        Assert.assertEquals((long)fileSystem.getDefaultBlockSize(p), (long)1024L);
        Assert.assertEquals((int)fileSystem.getDefaultReplication(p), (int)10);
        byte[] buffer = new byte[PAGE_SIZE * 2];
        int pageOffset = PAGE_SIZE;
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + 10, buffer, 0, 100), (int)100);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 100L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
        TestingCacheUtils.validateBuffer(this.data, pageOffset + 10, buffer, 0, 100);
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + 20, buffer, 0, 90), (int)90);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 90L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 0L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, 0L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
        TestingCacheUtils.validateBuffer(this.data, pageOffset + 20, buffer, 0, 90);
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + PAGE_SIZE - 10, buffer, 0, 100), (int)100);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 10L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 90L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
        TestingCacheUtils.validateBuffer(this.data, pageOffset + PAGE_SIZE - 10, buffer, 0, 100);
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, pageOffset - 10, buffer, 10, 50), (int)50);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 40L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 10L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
        TestingCacheUtils.validateBuffer(this.data, pageOffset - 10, buffer, 10, 50);
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + PAGE_SIZE * 3, buffer, 40, 50), (int)50);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 50L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
        TestingCacheUtils.validateBuffer(this.data, pageOffset + PAGE_SIZE * 3, buffer, 40, 50);
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + PAGE_SIZE * 2 - 10, buffer, 400, PAGE_SIZE + 20), (int)(PAGE_SIZE + 20));
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 20L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
        TestingCacheUtils.validateBuffer(this.data, pageOffset + PAGE_SIZE * 2 - 10, buffer, 400, PAGE_SIZE + 20);
    }

    @Test(invocationCount=10)
    public void testStress() throws ExecutionException, InterruptedException, URISyntaxException, IOException {
        CacheConfig cacheConfig = new CacheConfig().setCacheType(CacheType.ALLUXIO).setCachingEnabled(true).setBaseDirectory(this.cacheDirectory);
        AlluxioCacheConfig alluxioCacheConfig = new AlluxioCacheConfig().setMaxCacheSize(new DataSize(10.0, DataSize.Unit.KILOBYTE));
        Configuration configuration = this.getHdfsConfiguration(cacheConfig, alluxioCacheConfig);
        AlluxioCachingFileSystem cachingFileSystem = this.cachingFileSystem(configuration);
        TestingCacheUtils.stressTest(this.data, (position, buffer, offset, length) -> {
            try {
                this.readFully(cachingFileSystem, position, buffer, offset, length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L, expectedExceptions={IOException.class})
    public void testSyncRestoreFailure() throws Exception {
        URI badCacheDirectory = Files.createTempDirectory("alluxio_cache_bad", new FileAttribute[0]).toUri();
        File cacheDirectory = new File(badCacheDirectory.getPath());
        cacheDirectory.setWritable(false);
        CacheConfig cacheConfig = new CacheConfig().setCacheType(CacheType.ALLUXIO).setCachingEnabled(true).setBaseDirectory(badCacheDirectory);
        AlluxioCacheConfig alluxioCacheConfig = new AlluxioCacheConfig();
        Configuration configuration = this.getHdfsConfiguration(cacheConfig, alluxioCacheConfig);
        try {
            this.cachingFileSystem(configuration);
        }
        finally {
            cacheDirectory.setWritable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testBasicReadWithAsyncRestoreFailure() throws Exception {
        File cacheDirectory = new File(this.cacheDirectory.getPath());
        cacheDirectory.setWritable(false);
        CacheConfig cacheConfig = new CacheConfig().setCacheType(CacheType.ALLUXIO).setCachingEnabled(true).setBaseDirectory(this.cacheDirectory);
        AlluxioCacheConfig alluxioCacheConfig = new AlluxioCacheConfig();
        Configuration configuration = this.getHdfsConfiguration(cacheConfig, alluxioCacheConfig);
        configuration.set("alluxio.user.client.cache.async.restore.enabled", String.valueOf(true));
        try {
            AlluxioCachingFileSystem fileSystem = this.cachingFileSystem(configuration);
            long state = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_STATE.getName()).getCount();
            Assert.assertTrue((state == (long)CacheManager.State.READ_ONLY.getValue() || state == (long)CacheManager.State.NOT_IN_USE.getValue() ? 1 : 0) != 0);
            byte[] buffer = new byte[PAGE_SIZE * 2];
            int pageOffset = PAGE_SIZE;
            this.resetBaseline();
            Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + 10, buffer, 0, 100), (int)100);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 100L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
            TestingCacheUtils.validateBuffer(this.data, pageOffset + 10, buffer, 0, 100);
            this.resetBaseline();
            Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + 20, buffer, 0, 90), (int)90);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 90L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
            TestingCacheUtils.validateBuffer(this.data, pageOffset + 20, buffer, 0, 90);
            this.resetBaseline();
            Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + PAGE_SIZE - 10, buffer, 0, 100), (int)100);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 100L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, 2 * PAGE_SIZE);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
            TestingCacheUtils.validateBuffer(this.data, pageOffset + PAGE_SIZE - 10, buffer, 0, 100);
            this.resetBaseline();
            Assert.assertEquals((int)this.readFully(fileSystem, pageOffset - 10, buffer, 10, 50), (int)50);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 50L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, 2 * PAGE_SIZE);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
            TestingCacheUtils.validateBuffer(this.data, pageOffset - 10, buffer, 10, 50);
            this.resetBaseline();
            Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + PAGE_SIZE * 3, buffer, 40, 50), (int)50);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 50L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
            TestingCacheUtils.validateBuffer(this.data, pageOffset + PAGE_SIZE * 3, buffer, 40, 50);
            this.resetBaseline();
            Assert.assertEquals((int)this.readFully(fileSystem, pageOffset + PAGE_SIZE * 2 - 10, buffer, 400, PAGE_SIZE + 20), (int)(PAGE_SIZE + 20));
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, PAGE_SIZE + 20);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, 3 * PAGE_SIZE);
            this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
            TestingCacheUtils.validateBuffer(this.data, pageOffset + PAGE_SIZE * 2 - 10, buffer, 400, PAGE_SIZE + 20);
            state = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_STATE.getName()).getCount();
            Assert.assertTrue((state == (long)CacheManager.State.READ_ONLY.getValue() || state == (long)CacheManager.State.NOT_IN_USE.getValue() ? 1 : 0) != 0);
        }
        finally {
            cacheDirectory.setWritable(true);
        }
    }

    @Test(timeOut=30000L)
    public void testQuotaBasics() throws Exception {
        DataSize quotaSize = DataSize.succinctDataSize((double)1.0, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        CacheQuota cacheQuota = new CacheQuota("test.table", Optional.of(quotaSize));
        CacheConfig cacheConfig = new CacheConfig().setCacheType(CacheType.ALLUXIO).setCachingEnabled(true).setBaseDirectory(this.cacheDirectory).setValidationEnabled(false).setCacheQuotaScope(CacheQuotaScope.TABLE);
        AlluxioCacheConfig alluxioCacheConfig = new AlluxioCacheConfig().setCacheQuotaEnabled(true);
        Configuration configuration = this.getHdfsConfiguration(cacheConfig, alluxioCacheConfig);
        AlluxioCachingFileSystem fileSystem = this.cachingFileSystem(configuration);
        byte[] buffer = new byte[10240];
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, cacheQuota, 42L, buffer, 0, 100), (int)100);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 100L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
        TestingCacheUtils.validateBuffer(this.data, 42L, buffer, 0, 100);
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, cacheQuota, 47L, buffer, 0, 9000), (int)9000);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, PAGE_SIZE - 47);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 9000 - PAGE_SIZE + 47);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, 9000 / PAGE_SIZE * PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 9000 / PAGE_SIZE * PAGE_SIZE);
        TestingCacheUtils.validateBuffer(this.data, 47L, buffer, 0, 9000);
    }

    @Test(timeOut=30000L)
    public void testQuotaUpdated() throws Exception {
        CacheQuota smallCacheQuota = new CacheQuota("test.table", Optional.of(DataSize.succinctDataSize((double)1.0, (DataSize.Unit)DataSize.Unit.KILOBYTE)));
        CacheConfig cacheConfig = new CacheConfig().setCacheType(CacheType.ALLUXIO).setCachingEnabled(true).setBaseDirectory(this.cacheDirectory).setValidationEnabled(false).setCacheQuotaScope(CacheQuotaScope.TABLE);
        AlluxioCacheConfig alluxioCacheConfig = new AlluxioCacheConfig().setCacheQuotaEnabled(true);
        Configuration configuration = this.getHdfsConfiguration(cacheConfig, alluxioCacheConfig);
        AlluxioCachingFileSystem fileSystem = this.cachingFileSystem(configuration);
        byte[] buffer = new byte[10240];
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, smallCacheQuota, 0L, buffer, 0, 9000), (int)9000);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 0L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 9000L);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, (9000 / PAGE_SIZE + 1) * PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 9000 / PAGE_SIZE * PAGE_SIZE);
        TestingCacheUtils.validateBuffer(this.data, 0L, buffer, 0, 9000);
        CacheQuota largeCacheQuota = new CacheQuota("test.table", Optional.of(DataSize.succinctDataSize((double)10.0, (DataSize.Unit)DataSize.Unit.KILOBYTE)));
        this.resetBaseline();
        Assert.assertEquals((int)this.readFully(fileSystem, largeCacheQuota, 0L, buffer, 0, 9000), (int)9000);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE, 9000 - 9000 / PAGE_SIZE * PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL, 9000 / PAGE_SIZE * PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL, 9000 / PAGE_SIZE * PAGE_SIZE);
        this.checkMetrics(MetricKey.CLIENT_CACHE_BYTES_EVICTED, 0L);
        TestingCacheUtils.validateBuffer(this.data, 0L, buffer, 0, 9000);
    }

    @Test(invocationCount=10)
    public void testStressWithQuota() throws ExecutionException, InterruptedException, URISyntaxException, IOException {
        CacheQuota cacheQuota = new CacheQuota("test.table", Optional.of(DataSize.succinctDataSize((double)5.0, (DataSize.Unit)DataSize.Unit.KILOBYTE)));
        CacheConfig cacheConfig = new CacheConfig().setCacheType(CacheType.ALLUXIO).setCachingEnabled(true).setValidationEnabled(false).setBaseDirectory(this.cacheDirectory).setCacheQuotaScope(CacheQuotaScope.TABLE);
        AlluxioCacheConfig alluxioCacheConfig = new AlluxioCacheConfig().setMaxCacheSize(new DataSize(10.0, DataSize.Unit.KILOBYTE)).setCacheQuotaEnabled(true);
        Configuration configuration = this.getHdfsConfiguration(cacheConfig, alluxioCacheConfig);
        AlluxioCachingFileSystem cachingFileSystem = this.cachingFileSystem(configuration);
        TestingCacheUtils.stressTest(this.data, (position, buffer, offset, length) -> {
            try {
                this.readFully(cachingFileSystem, cacheQuota, position, buffer, offset, length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Test(timeOut=30000L)
    public void testInitialization() throws Exception {
        int pageSize = (int)new DataSize(8.0, DataSize.Unit.KILOBYTE).toBytes();
        int maxCacheSize = (int)new DataSize(512.0, DataSize.Unit.MEGABYTE).toBytes();
        String jmxClass = "alluxio.metrics.sink.JmxSink";
        String metricsDomain = "com.facebook.alluxio";
        Configuration configuration = new Configuration();
        configuration.set("alluxio.user.local.cache.enabled", "true");
        configuration.set("alluxio.user.client.cache.dirs", this.cacheDirectory.getPath());
        configuration.set("alluxio.user.client.cache.page.size", Integer.toString(pageSize));
        configuration.set("alluxio.user.client.cache.size", Integer.toString(maxCacheSize));
        configuration.set("sink.jmx.class", jmxClass);
        configuration.set("sink.jmx.domain", metricsDomain);
        AlluxioCachingFileSystem fileSystem = this.cachingFileSystem(configuration);
        Configuration conf = fileSystem.getConf();
        Assert.assertTrue((boolean)conf.getBoolean("alluxio.user.local.cache.enabled", false));
        Assert.assertEquals((String)this.cacheDirectory.getPath(), (String)conf.get("alluxio.user.client.cache.dirs", "bad result"));
        Assert.assertEquals((int)pageSize, (int)conf.getInt("alluxio.user.client.cache.page.size", 0));
        Assert.assertEquals((int)maxCacheSize, (int)conf.getInt("alluxio.user.client.cache.size", 0));
        Assert.assertEquals((String)jmxClass, (String)conf.get("sink.jmx.class", "bad result"));
        Assert.assertEquals((String)metricsDomain, (String)conf.get("sink.jmx.domain", "bad result"));
    }

    private void resetCacheManager() throws Exception {
        CacheManager manager;
        Field field = CacheManager.Factory.class.getDeclaredField("CACHE_MANAGER");
        field.setAccessible(true);
        AtomicReference managerReference = (AtomicReference)field.get(null);
        if (managerReference != null && (manager = (CacheManager)managerReference.getAndSet(null)) != null) {
            manager.close();
        }
    }

    private void resetBaseline() {
        this.updateBaseline(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE);
        this.updateBaseline(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL);
        this.updateBaseline(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL);
        this.updateBaseline(MetricKey.CLIENT_CACHE_BYTES_EVICTED);
    }

    private void updateBaseline(MetricKey metricsKey) {
        this.baseline.put(metricsKey.getName(), MetricsSystem.meter((String)metricsKey.getName()).getCount());
    }

    private void checkMetrics(MetricKey metricsKey, long expected) {
        Assert.assertEquals((long)(MetricsSystem.meter((String)metricsKey.getName()).getCount() - this.baseline.getOrDefault(metricsKey.getName(), 0L)), (long)expected);
    }

    private AlluxioCachingFileSystem cachingFileSystem(Configuration configuration) throws URISyntaxException, IOException {
        HashMap<Path, byte[]> files = new HashMap<Path, byte[]>();
        files.put(new Path(this.testFilePath), this.data);
        TestingFileSystem testingFileSystem = new TestingFileSystem(files, configuration);
        URI uri = new URI("alluxio://test:8020/");
        AlluxioCachingFileSystem cachingFileSystem = new AlluxioCachingFileSystem((ExtendedFileSystem)testingFileSystem, uri);
        cachingFileSystem.initialize(uri, configuration);
        return cachingFileSystem;
    }

    private Configuration getHdfsConfiguration(CacheConfig cacheConfig, AlluxioCacheConfig alluxioCacheConfig) {
        AlluxioCachingConfigurationProvider provider = new AlluxioCachingConfigurationProvider(cacheConfig, alluxioCacheConfig);
        Configuration configuration = new Configuration();
        provider.updateConfiguration(configuration, null, null);
        if (cacheConfig.isCachingEnabled() && cacheConfig.getCacheType() == CacheType.ALLUXIO) {
            configuration.set("alluxio.user.client.cache.page.size", Integer.toString(PAGE_SIZE));
            configuration.set("alluxio.user.client.cache.async.restore.enabled", String.valueOf(false));
        }
        return configuration;
    }

    private int readFully(AlluxioCachingFileSystem fileSystem, long position, byte[] buffer, int offset, int length) throws Exception {
        return this.readFully(fileSystem, CacheQuota.NO_CACHE_CONSTRAINTS, position, buffer, offset, length);
    }

    private int readFully(AlluxioCachingFileSystem fileSystem, CacheQuota quota, long position, byte[] buffer, int offset, int length) throws Exception {
        try (FSDataInputStream stream = fileSystem.openFile(new Path(this.testFilePath), new HiveFileContext(true, quota, Optional.empty(), OptionalLong.of(DATA_LENGTH), OptionalLong.of(offset), OptionalLong.of(length), 0L, false));){
            int n = stream.read(position, buffer, offset, length);
            return n;
        }
    }

    private static class TestingFileSystem
    extends ExtendedFileSystem {
        private final Map<Path, byte[]> files;

        TestingFileSystem(Map<Path, byte[]> files, Configuration configuration) {
            this.files = files;
            this.setConf(configuration);
        }

        public FileStatus getFileStatus(Path path) {
            if (this.files.containsKey(path)) {
                return this.generateURIStatus(path, this.files.get(path).length);
            }
            return null;
        }

        private FileStatus generateURIStatus(Path path, int length) {
            return new FileStatus((long)length, false, 1, 512L, 0L, 0L, null, null, null, path);
        }

        public URI getUri() {
            return null;
        }

        public FSDataInputStream open(Path path, int bufferSize) {
            return new ByteArrayDataInputStream(this.files.get(path));
        }

        public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            return null;
        }

        public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) {
            return null;
        }

        public boolean rename(Path source, Path destination) {
            return false;
        }

        public boolean delete(Path path, boolean recursive) {
            return false;
        }

        public FileStatus[] listStatus(Path path) {
            return new FileStatus[0];
        }

        public void setWorkingDirectory(Path directory) {
        }

        public Path getWorkingDirectory() {
            return null;
        }

        public boolean mkdirs(Path path, FsPermission permission) {
            return false;
        }

        public short getDefaultReplication() {
            throw new NotImplementedException("getDefaultReplication not implemented");
        }

        public short getDefaultReplication(Path path) {
            return 10;
        }

        public long getDefaultBlockSize() {
            throw new NotImplementedException("getDefaultBlockSize not implemented");
        }

        public long getDefaultBlockSize(Path path) {
            return 1024L;
        }

        private static class ByteArrayDataInputStream
        extends FSDataInputStream {
            public ByteArrayDataInputStream(byte[] bytes) {
                super((InputStream)new ByteArraySeekableStream(bytes));
            }
        }
    }
}

