/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import com.facebook.presto.cache.TestingCacheUtils;
import com.facebook.presto.cache.alluxio.ByteArraySeekableStream;
import com.facebook.presto.cache.alluxio.CacheValidatingInputStream;
import com.google.common.base.VerifyException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCacheValidatingInputStream {
    @Test
    public void testValidateDataEnabledWithDataMismatch() throws IOException {
        byte[] inputData = new byte[]{1, 2, 3};
        byte[] corruptedData = new byte[]{1, 3, 3};
        TestFSDataInputStream dataTierInputStream = new TestFSDataInputStream(inputData);
        TestFSDataInputStream fileInStream = new TestFSDataInputStream(corruptedData);
        CacheValidatingInputStream fileInputStream = new CacheValidatingInputStream((FSDataInputStream)fileInStream, (FSDataInputStream)dataTierInputStream);
        byte[] buffer = new byte[3];
        try {
            fileInputStream.readFully(0L, buffer, 0, buffer.length);
            Assert.fail((String)"Data validation didn't work for mismatched data.");
        }
        catch (VerifyException ex) {
            Assert.assertEquals((String)ex.getMessage(), (String)"corrupted buffer at position 1");
        }
    }

    @Test
    public void testValidateDataEnabledWithDataMatched() throws IOException {
        byte[] inputData = new byte[]{1, 2, 3};
        TestFSDataInputStream dataTierInputStream = new TestFSDataInputStream(inputData);
        TestFSDataInputStream fileInStream = new TestFSDataInputStream(inputData);
        CacheValidatingInputStream fileInputStream = new CacheValidatingInputStream((FSDataInputStream)fileInStream, (FSDataInputStream)dataTierInputStream);
        byte[] buffer = new byte[3];
        fileInputStream.readFully(0L, buffer, 0, buffer.length);
        TestingCacheUtils.validateBuffer(inputData, 0L, buffer, 0, inputData.length);
    }

    @Test
    public void testInteractionWithDataTierInputStream() throws IOException {
        byte[] inputData = new byte[]{1, 2, 3};
        TestFSDataInputStream dataTierInputStream = new TestFSDataInputStream(inputData);
        TestFSDataInputStream fileInStream = new TestFSDataInputStream(inputData);
        CacheValidatingInputStream validationEnabledInputStream = new CacheValidatingInputStream((FSDataInputStream)fileInStream, (FSDataInputStream)dataTierInputStream);
        validationEnabledInputStream.seek(2L);
        Assert.assertEquals((long)dataTierInputStream.getPos(), (long)2L);
        Assert.assertEquals((long)fileInStream.getPos(), (long)2L);
        validationEnabledInputStream.seek(1L);
        Assert.assertEquals((long)dataTierInputStream.getPos(), (long)1L);
        Assert.assertEquals((long)fileInStream.getPos(), (long)1L);
    }

    private static class TestFSDataInputStream
    extends FSDataInputStream {
        TestFSDataInputStream(byte[] data) {
            super((InputStream)new ByteArraySeekableStream(data));
        }
    }
}

