/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.filemerge;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.cache.filemerge.FileMergeCacheConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestFileMergeCacheConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FileMergeCacheConfig)ConfigAssertions.recordDefaults(FileMergeCacheConfig.class)).setMaxCachedEntries(1000).setMaxInMemoryCacheSize(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setCacheTtl(new Duration(2.0, TimeUnit.DAYS)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"cache.max-cached-entries", (Object)"5").put((Object)"cache.max-in-memory-cache-size", (Object)"42MB").put((Object)"cache.ttl", (Object)"10s").build();
        FileMergeCacheConfig expected = new FileMergeCacheConfig().setMaxCachedEntries(5).setMaxInMemoryCacheSize(new DataSize(42.0, DataSize.Unit.MEGABYTE)).setCacheTtl(new Duration(10.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

