/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.filemerge;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.CacheStats;
import com.facebook.presto.cache.FileReadRequest;
import com.facebook.presto.cache.TestingCacheUtils;
import com.facebook.presto.cache.filemerge.FileMergeCacheConfig;
import com.facebook.presto.cache.filemerge.FileMergeCacheManager;
import com.facebook.presto.hive.CacheQuota;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFileMergeCacheManager {
    private static final int DATA_LENGTH = (int)new DataSize(20.0, DataSize.Unit.KILOBYTE).toBytes();
    private final byte[] data = new byte[DATA_LENGTH];
    private final ExecutorService flushExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)"test-cache-flusher-%s"));
    private final ExecutorService removeExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)"test-cache-remover-%s"));
    private final ScheduledExecutorService cacheSizeCalculator = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"hive-cache-size-calculator-%s"));
    private URI cacheDirectory;
    private URI fileDirectory;
    private File dataFile;

    @BeforeClass
    public void setup() throws IOException {
        new Random().nextBytes(this.data);
        this.cacheDirectory = Files.createTempDirectory("cache", new FileAttribute[0]).toUri();
        this.fileDirectory = Files.createTempDirectory("file", new FileAttribute[0]).toUri();
        this.dataFile = new File(this.fileDirectory.getPath() + "/data");
        Files.write(new File(this.dataFile.toString()).toPath(), this.data, StandardOpenOption.CREATE_NEW);
    }

    @AfterClass
    public void close() throws IOException {
        this.flushExecutor.shutdown();
        this.removeExecutor.shutdown();
        Preconditions.checkState((this.cacheDirectory != null ? 1 : 0) != 0);
        Preconditions.checkState((this.fileDirectory != null ? 1 : 0) != 0);
        Files.deleteIfExists(this.dataFile.toPath());
        File[] files = new File(this.cacheDirectory).listFiles();
        if (files != null) {
            for (File file : files) {
                Files.delete(file.toPath());
            }
        }
        Files.deleteIfExists(new File(this.cacheDirectory).toPath());
        Files.deleteIfExists(new File(this.fileDirectory).toPath());
    }

    @Test(timeOut=30000L)
    public void testBasic() throws InterruptedException, ExecutionException, IOException {
        TestingCacheStats stats = new TestingCacheStats();
        CacheManager cacheManager = this.fileMergeCacheManager(stats);
        byte[] buffer = new byte[1024];
        Assert.assertFalse((boolean)this.readFully(cacheManager, CacheQuota.NO_CACHE_CONSTRAINTS, 42L, buffer, 0, 100));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)1L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)0L);
        stats.trigger();
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 42L, buffer, 0, 100);
        Assert.assertTrue((boolean)this.readFully(cacheManager, CacheQuota.NO_CACHE_CONSTRAINTS, 47L, buffer, 0, 90));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)1L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)1L);
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 47L, buffer, 0, 90);
        Assert.assertFalse((boolean)this.readFully(cacheManager, CacheQuota.NO_CACHE_CONSTRAINTS, 52L, buffer, 0, 100));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)2L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)1L);
        stats.trigger();
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 52L, buffer, 0, 100);
        Assert.assertFalse((boolean)this.readFully(cacheManager, CacheQuota.NO_CACHE_CONSTRAINTS, 32L, buffer, 10, 50));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)3L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)1L);
        stats.trigger();
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 32L, buffer, 10, 50);
        Assert.assertFalse((boolean)this.readFully(cacheManager, CacheQuota.NO_CACHE_CONSTRAINTS, 200L, buffer, 40, 50));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)4L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)1L);
        stats.trigger();
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 200L, buffer, 40, 50);
        Assert.assertFalse((boolean)this.readFully(cacheManager, CacheQuota.NO_CACHE_CONSTRAINTS, 40L, buffer, 400, 200));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)5L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)1L);
        stats.trigger();
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 40L, buffer, 400, 200);
    }

    @Test(invocationCount=10)
    public void testStress() throws ExecutionException, InterruptedException {
        CacheConfig cacheConfig = new CacheConfig().setBaseDirectory(this.cacheDirectory);
        FileMergeCacheConfig fileMergeCacheConfig = new FileMergeCacheConfig().setCacheTtl(new Duration(10.0, TimeUnit.MILLISECONDS));
        CacheManager cacheManager = this.fileMergeCacheManager(cacheConfig, fileMergeCacheConfig);
        TestingCacheUtils.stressTest(this.data, (position, buffer, offset, length) -> this.readFully(cacheManager, CacheQuota.NO_CACHE_CONSTRAINTS, position, buffer, offset, length));
    }

    @Test(timeOut=30000L)
    public void testQuota() throws InterruptedException, ExecutionException, IOException {
        TestingCacheStats stats = new TestingCacheStats();
        CacheManager cacheManager = this.fileMergeCacheManager(stats);
        byte[] buffer = new byte[10240];
        CacheQuota cacheQuota = new CacheQuota("test.table", Optional.of(DataSize.succinctDataSize((double)1.0, (DataSize.Unit)DataSize.Unit.KILOBYTE)));
        Assert.assertFalse((boolean)this.readFully(cacheManager, cacheQuota, 42L, buffer, 0, 100));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)1L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)0L);
        Assert.assertEquals((long)stats.getQuotaExceed(), (long)0L);
        stats.trigger();
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 42L, buffer, 0, 100);
        Assert.assertFalse((boolean)this.readFully(cacheManager, cacheQuota, 47L, buffer, 0, 9000));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)1L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)0L);
        Assert.assertEquals((long)stats.getQuotaExceed(), (long)1L);
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 47L, buffer, 0, 90);
        Assert.assertTrue((boolean)this.readFully(cacheManager, cacheQuota, 47L, buffer, 0, 90));
        Assert.assertEquals((long)stats.getCacheMiss(), (long)1L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)1L);
        Assert.assertEquals((long)stats.getQuotaExceed(), (long)1L);
        Assert.assertEquals((long)stats.getInMemoryRetainedBytes(), (long)0L);
        TestingCacheUtils.validateBuffer(this.data, 47L, buffer, 0, 90);
    }

    private CacheManager fileMergeCacheManager(CacheConfig cacheConfig, FileMergeCacheConfig fileMergeCacheConfig) {
        return new FileMergeCacheManager(cacheConfig, fileMergeCacheConfig, new CacheStats(), this.flushExecutor, this.removeExecutor, this.cacheSizeCalculator);
    }

    private CacheManager fileMergeCacheManager(CacheStats cacheStats) {
        CacheConfig cacheConfig = new CacheConfig();
        FileMergeCacheConfig fileMergeCacheConfig = new FileMergeCacheConfig();
        return new FileMergeCacheManager(cacheConfig.setBaseDirectory(this.cacheDirectory), fileMergeCacheConfig, cacheStats, this.flushExecutor, this.removeExecutor, this.cacheSizeCalculator);
    }

    private boolean readFully(CacheManager cacheManager, CacheQuota cacheQuota, long position, byte[] buffer, int offset, int length) throws IOException {
        FileReadRequest key = new FileReadRequest(new Path(this.dataFile.getAbsolutePath()), position, length);
        switch (cacheManager.get(key, buffer, offset, cacheQuota)) {
            case HIT: {
                return true;
            }
            case MISS: {
                RandomAccessFile file = new RandomAccessFile(this.dataFile.getAbsolutePath(), "r");
                file.seek(position);
                file.readFully(buffer, offset, length);
                file.close();
                cacheManager.put(key, Slices.wrappedBuffer((byte[])buffer, (int)offset, (int)length), CacheQuota.NO_CACHE_CONSTRAINTS);
                return false;
            }
        }
        return false;
    }

    private static class TestingCacheStats
    extends CacheStats {
        private SettableFuture<?> trigger = SettableFuture.create();

        public void addInMemoryRetainedBytes(long bytes) {
            super.addInMemoryRetainedBytes(bytes);
            if (bytes < 0L) {
                this.trigger.set(null);
            }
        }

        public void trigger() throws InterruptedException, ExecutionException {
            this.trigger.get();
            this.trigger = SettableFuture.create();
        }
    }
}

