/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.cache.CacheType;
import com.facebook.presto.hive.CacheQuotaScope;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;

public class CacheConfig {
    private boolean cachingEnabled;
    private CacheType cacheType;
    private URI baseDirectory;
    private boolean validationEnabled;
    private CacheQuotaScope cacheQuotaScope = CacheQuotaScope.GLOBAL;
    private Optional<DataSize> defaultCacheQuota = Optional.empty();
    private boolean lastModifiedTimeCheckEnabled;

    @Nullable
    public URI getBaseDirectory() {
        return this.baseDirectory;
    }

    @Config(value="cache.base-directory")
    @ConfigDescription(value="Base URI to cache data")
    public CacheConfig setBaseDirectory(URI dataURI) {
        this.baseDirectory = dataURI;
        return this;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    @Config(value="cache.validation-enabled")
    @ConfigDescription(value="Enable cache validation by comparing with actual data with cached data")
    public CacheConfig setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        return this;
    }

    @Config(value="cache.enabled")
    @ConfigDescription(value="Is cache enabled")
    public CacheConfig setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
        return this;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    @Config(value="cache.type")
    @ConfigDescription(value="Caching type")
    public CacheConfig setCacheType(CacheType cacheType) {
        this.cacheType = cacheType;
        return this;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public CacheQuotaScope getCacheQuotaScope() {
        return this.cacheQuotaScope;
    }

    @Config(value="cache.cache-quota-scope")
    public CacheConfig setCacheQuotaScope(CacheQuotaScope cacheQuotaScope) {
        this.cacheQuotaScope = cacheQuotaScope;
        return this;
    }

    public Optional<DataSize> getDefaultCacheQuota() {
        return this.defaultCacheQuota;
    }

    @Config(value="cache.default-cache-quota")
    public CacheConfig setDefaultCacheQuota(DataSize defaultCacheQuota) {
        if (defaultCacheQuota != null) {
            this.defaultCacheQuota = Optional.of(defaultCacheQuota);
        }
        return this;
    }

    public boolean isLastModifiedTimeCheckEnabled() {
        return this.lastModifiedTimeCheckEnabled;
    }

    @Config(value="cache.last-modified-time-check-enabled")
    @ConfigDescription(value="Enable the check of the last modified time for each cached file entry")
    public CacheConfig setLastModifiedTimeCheckEnabled(boolean lastModifiedTimeCheckEnabled) {
        this.lastModifiedTimeCheckEnabled = lastModifiedTimeCheckEnabled;
        return this;
    }
}

