/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import com.google.common.base.Verify;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

public class CacheValidatingInputStream
extends FSDataInputStream {
    private final FSDataInputStream inputStream;
    private final FSDataInputStream dataTierInputStream;

    public CacheValidatingInputStream(FSDataInputStream inputStream, FSDataInputStream dataTierInputStream) {
        super((InputStream)inputStream);
        this.inputStream = Objects.requireNonNull(inputStream, "InputStream is null");
        this.dataTierInputStream = Objects.requireNonNull(dataTierInputStream, "DataTierInputStream is null");
    }

    public int read() throws IOException {
        int outByte = this.inputStream.read();
        Verify.verify((this.dataTierInputStream.read() == outByte ? 1 : 0) != 0, (String)("corrupted buffer at position " + this.getPos()), (Object[])new Object[0]);
        return outByte;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        int bytes = this.inputStream.read(position, buffer, offset, length);
        byte[] validationBuffer = new byte[bytes];
        this.dataTierInputStream.read(position, validationBuffer, 0, bytes);
        for (int i = 0; i < bytes; ++i) {
            Verify.verify((buffer[offset + i] == validationBuffer[i] ? 1 : 0) != 0, (String)("corrupted buffer at position " + i), (Object[])new Object[0]);
        }
        return bytes;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = this.read(position + (long)totalBytesRead, buffer, offset + totalBytesRead, length - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new EOFException();
        }
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void seek(long position) throws IOException {
        this.inputStream.seek(position);
        this.dataTierInputStream.seek(position);
    }

    public long getPos() throws IOException {
        return this.inputStream.getPos();
    }

    public boolean seekToNewSource(long target) {
        throw new UnsupportedOperationException();
    }
}

